<?php

namespace Asics\Windcave\Observer;

use Magento\Checkout\Model\Session;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;

/**
 * class PreDispatchCheckoutObserver
 *  This observer is used primarily by HPP and triggered when a customer click "Back" from the browser.
 *  The main purpose of this observer is to allow the restoration of the cart for failed payment.
 */
class PreDispatchCheckoutObserver implements ObserverInterface
{
    /**
     * @STATUS_PENDING
     */
    private const STATUS_PENDING = 'pending';

    /**
     * @var Session
     */
    private Session $checkoutSession;

    /**
     * Constructor
     *
     * @param Session $checkoutSession
     */
    public function __construct(
        Session $checkoutSession
    ) {
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * Process the event
     *
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $lastRealOrder = $this->checkoutSession->getLastRealOrder();
        $payment = $lastRealOrder->getPayment();
        if (!isset($payment) || $payment === null) {
            return;
        }
        $info = $payment->getAdditionalInformation();
        if (isset($info) && !empty($info['DpsTxnRef'])) {
            return;
        }

        if ($lastRealOrder->getState() === Order::STATE_PENDING_PAYMENT
            && $lastRealOrder->getStatus() === Order::STATE_PENDING_PAYMENT) {
            $lastRealOrder->cancel()->save();
            $this->checkoutSession->restoreQuote();
        }
    }
}
