<?php

namespace BrittainWynyard\CheckoutAttributes\Helper;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Catalog\Model\Product;

class Data extends AbstractHelper
{
    protected $_eavAttribute;
    protected $productRepository;
    protected $productFactory;

    public function __construct(
        Context $context,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute $eavAttribute,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        array $data = []
    )
    {
        $this->_eavAttribute = $eavAttribute;
        $this->productRepository = $productRepository;
        parent::__construct($context);
    }

    public function getProductAttributeIdByCode($code)
    {
        $attributeId = $this->_eavAttribute->getIdByCode(Product::ENTITY, $code);
        //$attribute = $this->eavConfig->getAttribute('catalog_product', $code);
        return $attributeId;
    }

    public function getProductAttributeValueByCode($_product, $code) {
        $product = $this->productRepository->get($_product->getSku());
        if (is_object($attribute = $product->getResource()->getAttribute('asics_category'))) {
            return $attribute->getFrontend()->getValue($product);
        }
        return false;
    }
}
