<?php

declare(strict_types=1);

namespace BrittainWynyard\Csp\Plugin;

use Magento\Csp\Api\Data\PolicyInterface;
use Magento\Csp\Api\PolicyRendererInterface;
use Magento\Framework\App\Response\HttpInterface;
use Overdose\SafeProduction\Model\Config\EnvironmentConfig;

/**
 * Temporarily disable rendering the CSP headers on production
 *
 * This is required because production uses Akamai CDN, which has a maximum HTTP header size of 8192 bytes, and sending
 * the CSP header will exceed this limit. Once Akamai increases the maximum we can remove this plugin.
 */
class DisableRenderCspHeader
{
    public function __construct(
        private readonly EnvironmentConfig $environmentConfig,
    ) {
    }

    public function aroundRender(
        PolicyRendererInterface $subject,
        callable $proceed,
        PolicyInterface $policy,
        HttpInterface $response,
    ): void {
        if ($this->environmentConfig->getScope() === EnvironmentConfig::ENVIRONMENT_GENERAL_SCOPE_PROD) {
            return;
        }

        $proceed($policy, $response);
    }
}
