<?php
namespace Overdose\Cart\Setup\Patch\Data;

use Magento\Cms\Model\BlockFactory;
use Magento\Cms\Model\ResourceModel\Block as BlockResource;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Store\Model\Store;

class AddMiniCartBottomMemberBlock implements DataPatchInterface
{
    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param BlockFactory $blockFactory
     * @param BlockResource $blockResource
     */
    public function __construct(
        private ModuleDataSetupInterface $moduleDataSetup,
        private BlockFactory $blockFactory,
        private BlockResource $blockResource
    ) {
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->moduleDataSetup->startSetup();

        // Create OneASICS Membership Benefits Block
        $asicsBlockData = [
            'title' => 'OneASICS Membership Benefits',
            'identifier' => 'oneasics_membership_benefits',
            'content' => '<div class="oneasics-membership-benefits">
                            <div class="benefits-header">
                                <img src="{{view url="images/icons/oneasics_blue_horizontal.png"}}" alt="ASICS" class="asics-logo" />
                                <p class="benefits-text">Sign up for member-only offers, including a birthday surprise.</p>
                                <p class="benefits-subtext">Become a OneASICS member today! <a href="{{store url="nz/en-nz/oneasics/login"}}"
                                   class="join-button">Join For Free</a> or
                                <a href="{{store url="nz/en-nz/oneasics/login"}}"
                                   class="signin-button">Sign In</a></p>
                            </div>
                         </div>',
            'is_active' => 1,
            'stores' => [Store::DEFAULT_STORE_ID],
        ];

        try {
            $block = $this->blockFactory->create();
            $createdBlock = $block->load(
                'oneasics_membership_benefits',
                'identifier'
            );

            if ($createdBlock->getId()) {
                $createdBlock->setContent($asicsBlockData['content'])->save();
            } else {
                $block->setData($asicsBlockData);
                $this->blockResource->save($block);
            }
        } catch (\Exception $e) {
            throw new \Magento\Framework\Setup\Exception(
                __("Could not create CMS block: %1", $e->getMessage())
            );
        }

        $this->moduleDataSetup->endSetup();
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases(): array
    {
        return [];
    }
}