<?php
namespace Overdose\Cart\Setup\Patch\Data;

use Magento\Cms\Model\BlockFactory;
use Magento\Cms\Model\ResourceModel\Block as BlockResource;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Store\Model\Store;

class AddMiniCartSignInBlock implements DataPatchInterface
{
    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param BlockFactory $blockFactory
     * @param BlockResource $blockResource
     */
    public function __construct(
        private ModuleDataSetupInterface $moduleDataSetup,
        private BlockFactory $blockFactory,
        private BlockResource $blockResource
    ) {
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->moduleDataSetup->startSetup();

        // Create ASICS Membership Promo Block
        $asicsBlockData = [
            'title' => 'Cart Sidebar ASICS Member Promo',
            'identifier' => 'cart_sidebar_asics_member_promo',
            'content' => '<div class="mini-cart-membership-callout">
                            <div class="membership-header">
                                <img src="{{view url="images/icons/oneasics_blue_horizontal.png"}}" alt="ASICS" class="asics-logo" />
                            </div>
                            <div class="membership-content"><span>Exclusive Offers and Experiences!</span> <a href="{{store url="nz/en-nz/oneasics/login"}}"
                                   class="join-button">Join For Free</a> or
                                <a href="{{store url="nz/en-nz/oneasics/login"}}"
                                   class="signin-button">Sign In</a>
                            </div>
                         </div>',
            'is_active' => 1,
            'stores' => [Store::DEFAULT_STORE_ID],
        ];

        try {
            $block = $this->blockFactory->create();
            $createdBlock = $block->load(
                'cart_sidebar_asics_member_promo',
                'identifier'
            );

            if ($createdBlock->getId()) {
                $createdBlock->setContent($asicsBlockData['content'])->save();
            } else {
                $block->setData($asicsBlockData);
                $this->blockResource->save($block);
            }
        } catch (\Exception $e) {
            throw new \Magento\Framework\Setup\Exception(
                __("Could not create CMS block: %1", $e->getMessage())
            );
        }

        $this->moduleDataSetup->endSetup();
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases(): array
    {
        return [];
    }
}