<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/**
 * Product description block
 *
 * @author     Magento Core Team <core@magentocommerce.com>
 */
namespace Overdose\Catalog\Plugin\Block\Product\View;

use Magento\Catalog\Model\Product;

/**
 * @api
 * @since 100.0.2
 */
class Description extends \Magento\Catalog\Block\Product\View\Description
{
    /**
     * @var Product
     */
    protected $_product = null;

    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry = null;
    protected $categoryRepository;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Catalog\Model\CategoryRepository $categoryRepository,
        array $data = []
    ) {
        $this->_coreRegistry = $registry;
        $this->categoryRepository = $categoryRepository;
        parent::__construct($context, $registry, $data);
    }

    /**
     * @return Product
     */
    public function getProduct()
    {
        if (!$this->_product) {
            $this->_product = $this->_coreRegistry->registry('product');
        }
        return $this->_product;
    }

     /**
     * @return Product
     */
    public function getProductMainCategoryUrl()
    {
        $mainCategoryUrl = '';
        $product = $this->getProduct();
        if  ($product->getCustomAttribute('main_category'))
        {
            $categoryId = $product->getCustomAttribute('main_category')->getValue();
            $category = $this->categoryRepository->get($categoryId);
            $mainCategoryUrl = $category->getUrl();
        }
        return $mainCategoryUrl;
    }

    public function getSizeLabel()
    {
        $product = $this->getProduct();
        $attributeValue = $product->getData('asics_size_label');
        $attribute = $product->getResource()->getAttribute('asics_size_label');
        if ($attribute && $attribute->usesSource()) {
            $value = $attribute->getSource()->getOptionText($attributeValue);
        }
        return (isset($value) && $value) ? $value : 'Size:';
    }
}
