<?php
namespace Overdose\Catalog\Plugin;

/**
 * Class Config
 * @package Overdose\Catalog\Plugin
 */
class Config
{
    /**
     * @param \Magento\Catalog\Model\Config $catalogConfig
     * @param $options
     * @return array
     */
    public function afterGetAttributeUsedForSortByArray(\Magento\Catalog\Model\Config $catalogConfig, $options)
    {
        $optionsNew = ['name_a_z' => __('Product Name A-Z'), 'name_z_a' => __('Product Name Z-A'), 'price_low_to_high' => __('Lowest To Highest Price'), 'price_high_to_low' => __('Highest To Lowest Price')];
        $options = array_merge($options, $optionsNew);
        if (array_key_exists('name', $options)) {
            unset($options['name']);
        }
        if (array_key_exists('price', $options)) {
            unset($options['price']);
        }
        if (array_key_exists('position', $options)) {
            unset($options['position']);
        }
        return $options;
    }
}
