<?php

namespace Overdose\CatalogSortToolbar\Plugin\Model;
use Magento\Store\Model\StoreManagerInterface;
class Config
{
    protected $_storeManager;

    public function __construct(
        StoreManagerInterface $storeManager
    ) {
        $this->_storeManager = $storeManager;

    }

    /**
     * Adding custom options and changing labels
     *
     * @param \Magento\Catalog\Model\Config $catalogConfig
     * @param [] $options
     * @return []
     */
    public function afterGetAttributeUsedForSortByArray(\Magento\Catalog\Model\Config $catalogConfig, $options)
    {
        $optionsNew = [
            'name_a_z' => __('A-Z'),
            'name_z_a' => __('Z-A'),
            'price_low_to_high' => __('$-$$'),
            'price_high_to_low' => __('$$-$'),
            'newest' => __('Newest')
        ];
        $options = array_merge($options, $optionsNew);
        if (array_key_exists('name', $options)) {
            unset($options['name']);
        }
        if (array_key_exists('price', $options)) {
            unset($options['price']);
        }
        if (array_key_exists('position', $options)) {
            $options['position'] = __('Featured');
        }
        return $options;
    }
}
