<?php

namespace Overdose\CheckoutSuccess\Block\OnePage;

use Magento\Catalog\Helper\Image;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Pricing\Helper\Data;
use Magento\Framework\View\Element\Template\Context;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\Item;
use Magento\Sales\Model\Order\Address\Renderer as AddressRenderer;

class Success extends \Magento\Checkout\Block\Onepage\Success
{
    const PRODUCT_IMAGE_WIDTH  = 200;
    const PRODUCT_IMAGE_HEIGHT = 200;

    /** @var Image */
    protected $imageHelper;

    /** @var Data */
    public $priceHelper;

    /** @var ScopeConfigInterface */
    protected $scopeConfig;

        /**
     * @var AddressRenderer
     */
    protected $addressRenderer;

    /**
     * @param Context $context
     * @param AddressRenderer $addressRenderer
     * @param Session $checkoutSession
     * @param Order\Config $orderConfig
     * @param \Magento\Framework\App\Http\Context $httpContext
     * @param Image $imageHelper
     * @param Data $priceHelper
     * @param ScopeConfigInterface $scopeConfig
     * @param array $data
     */
    public function __construct(
        Context $context,
        AddressRenderer $addressRenderer,
        Session $checkoutSession,
        Order\Config $orderConfig,
        \Magento\Framework\App\Http\Context $httpContext,
        Image $imageHelper,
        Data $priceHelper,
        ScopeConfigInterface $scopeConfig,
        array $data = []
    ) {
        parent::__construct($context, $checkoutSession, $orderConfig, $httpContext, $data);
        $this->addressRenderer = $addressRenderer;
        $this->imageHelper = $imageHelper;
        $this->priceHelper = $priceHelper;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Get order
     *
     * @return Order
     */
    public function getOrder()
    {
        return $this->_checkoutSession->getLastRealOrder();
    }

        /**
     * Returns string with formatted address
     *
     * @param Address $address
     * @return null|string
     */
    public function getFormattedAddress($address)
    {
        return $this->addressRenderer->format($address, 'html');
    }

    /**
     * Get product image url
     *
     * @param Item $item
     * @return string
     */
    public function getProductImage(Item $item)
    {
        $imageUrl = $this->imageHelper->init($item->getProduct(), 'small_image')
            ->setImageFile($item->getProduct()->getImage())->resize(
                static::PRODUCT_IMAGE_WIDTH,
                static::PRODUCT_IMAGE_HEIGHT
            )->getUrl();

        return $imageUrl;
    }

    /**
     * Get phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->scopeConfig->getValue('general/store_information/phone');
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->scopeConfig->getValue('trans_email/ident_general/email');
    }
}
