<?php declare(strict_types=1);

namespace Overdose\CheckoutSuccess\Setup\Patch\Data;

use Magento\Cms\Model\BlockFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class AddCheckoutCmsBlocks implements DataPatchInterface
{
    private $moduleDataSetup;
    private $blockFactory;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        BlockFactory $blockFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->blockFactory = $blockFactory;
    }

    public function apply()
    {
        $this->moduleDataSetup->startSetup();

        $blocksData = [
            [
                'title' => 'Checkout OneASICS Login Prompt',
                'identifier' => 'checkout_oneasics_login_prompt',
                'content' => <<<HTML
<div class="block-content" style="display: flex; align-items: center; gap: 20px; padding: 24px 24px 24px 10px; background: #F1F2F2; border-radius: 10px;">
    <img src="{{media url=wysiwyg/OneASICS_Logo.png}}" alt="OneASICS Logo" width="250"/>
    <div class="content-wrapper">
        <p style="font-size: 0.9375rem;">Want special offers, exclusive access and more? Become a OneASICS&trade; member!</p>
        <div style="display: flex; gap: 10px; flex-wrap: wrap; justify-content: center;">
            <a class="button--primary" style="flex: 1; min-width: 125px !important;" href="https://www.asics.com/nz/en-nz/oneasics/login/">Sign In</a>
            <a class="button--primary" style="flex: 1; min-width: 125px !important; background: #485CC7 !important;" href="https://www.asics.com/nz/en-nz/oneasics/login/">Join For Free</a>
        </div>
    </div>
</div>
HTML
            ],
            [
                'title' => 'Checkout Payment Terms',
                'identifier' => 'checkout_payment_terms',
                'content' => <<<HTML
<p>
    By clicking the Pay Securely Now button, you confirm that you have read, understood and accept our
    <a href="/nz/en-nz/terms-of-sale">Terms of Sale</a>,
    <a href="/nz/en-nz/click-and-collect">Click and Collect Terms</a> (if applicable),
    <a href="/nz/en-nz/returns">Returns Policy</a> and
    <a href="/nz/en-nz/privacy-policy">Privacy Policy</a>.
</p>
HTML
            ]
        ];

        foreach ($blocksData as $data) {
            $existingBlock = $this->blockFactory->create()->load($data['identifier'], 'identifier');
            if ($existingBlock->getId()) {
                // Block already exists, skip creation
                continue;
            }
            $this->blockFactory->create()->setData([
                'title' => $data['title'],
                'identifier' => $data['identifier'],
                'content' => $data['content'],
                'is_active' => 1,
                'stores' => [0]
            ])->save();
        }

        $this->moduleDataSetup->endSetup();
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }
}
