define([
    'jquery',
    'uiComponent',
    'Overdose_DataLayer/js/cookies'
], function ($, Component, cookies) {
    'use strict';

    return {
        pushData: function (email = null, cookieEventName = null) {
            let cookieName = cookieEventName || 'tmpDataLayer';
            let tmpDataLayer = cookies.getCookie(cookieName);

            if (tmpDataLayer !== null && email === null) {
                tmpDataLayer = cookies.parseJson(tmpDataLayer);
                if (typeof window.dataLayer === 'undefined') {
                    window.dataLayer = [];
                }
                window.dataLayer.push(tmpDataLayer);
                cookies.delCookie(cookieName);
            }

            if (email !== null) {
                this.sha256(email);
                if (tmpDataLayer !== null) { //checkout index page, ajax email field
                    cookies.delCookie(cookieName);
                }
            }
        },

        pushProductClickDataLayer: function (productId, urlRedirect) {
            const product = {};
            product.product_id = productId;
            if (Array.isArray(window.dataLayer)) {
                window.dataLayer.forEach(function (entry) {
                    if (entry.event === 'view_item_list') {
                        if (entry.ecommerce) {
                            if (entry.ecommerce.item_list_id) {
                                product.item_list_id = entry.ecommerce.item_list_id;
                            }
                            if (entry.ecommerce.item_list_name) {
                                product.item_list_name = entry.ecommerce.item_list_name;
                            }
                            if (Array.isArray(entry.ecommerce.items)) {
                                product.item_list = entry.ecommerce.items;
                            }
                        }
                    }
                });
            }
            var reducedProduct = {
                product_id: product.product_id,
                item_list_id: product.item_list_id,
                item_list_name: product.item_list_name,
                item_list: Array.isArray(product.item_list) ? product.item_list.map(function(item) {
                    return {
                        item_id: item.item_id,
                        index: item.index,
                        item_list_id: item.item_list_id,
                        item_list_name: item.item_list_name
                    };
                }) : []
            };
            cookies.setCookie('od-product-click', JSON.stringify(reducedProduct), 2);
            window.location.href = urlRedirect;
        },

        sha256: function (email) {
            if (typeof window.dataLayer === 'undefined') {
                window.dataLayer = [];
            }
        }
    };
});
