<?php

declare(strict_types=1);

namespace Overdose\ProductBanners\Plugin\Catalog\Model;

class Product
{
    /**
     * if it's banner we redirect to banner_url attribute
     *
     * @param \Magento\Catalog\Model\Product $subject
     * @param string $result
     * @param bool|null $useSid
     * @return string
     * @see \Magento\Catalog\Model\Product::getProductUrl
     */
    public function afterGetProductUrl(
        \Magento\Catalog\Model\Product $subject,
        string $result,
        $useSid = null
    ) {
        if ($subject->getTypeId() === \Overdose\ProductBanners\Model\Product\Type\Banner::PRODUCT_TYPE_BANNER) {
            return $subject->getBannerUrl();
        }

        return $result;
    }
}