<?php
namespace Overdose\Sales\ViewModel;

use Magento\Catalog\Block\Product\ImageBuilder;
use Magento\Catalog\Model\Product as ProductModel;
use Magento\Framework\View\Element\Block\ArgumentInterface;

/**
 * Class Product
 * @package Overdose\Sales\ViewModel
 */
class Product implements ArgumentInterface
{
    /**
     * @var ImageBuilder
     */
    protected $imageBuilder;

    /**
     * @var
     */
    protected $listProduct;

    /**
     * Product constructor.
     * @param ImageBuilder $imageBuilder
     * @param \Magento\Catalog\Block\Product\ListProduct $listProduct
     */
    public function __construct(ImageBuilder $imageBuilder, \Magento\Catalog\Block\Product\ListProduct $listProduct)
    {
        $this->imageBuilder = $imageBuilder;
        $this->listProduct = $listProduct;
    }

    /**
     * Retrieve product image
     *
     * @param ProductModel $product
     * @param string $imageId
     * @param array $attributes
     * @return \Magento\Catalog\Block\Product\Image
     */
    public function getImage($product, $imageId, $attributes = [])
    {
        return $this->imageBuilder->setProduct($product)
            ->setImageId($imageId)
            ->setAttributes($attributes)
            ->create();
    }

    /**
     * @param $product
     * @return string
     */
    public function getAddToCartLink($product)
    {
        try {
            if ($product) {
                return $this->listProduct->getAddToCartUrl($product);
            }
        } catch (\Exception $exception) {
            $exception->getMessage();
        }
    }
}
