<?php

namespace Overdose\ShoeFinder\Block;

use Magento\Framework\View\Element\Template;

/**
 * Class ShoeFinder
 * @package Overdose\ShoeFinder\Block
 */
class ShoeFinder extends Template
{
    const IGNORE_ACTIONS = [
        'shoefinder_index_index',
        'catalog_product_view',        
        'checkout_cart_index',
        'checkout_index_index',        
        'checkout_onepage_success'
    ];
    
    /**
     * @param $image
     * @return string
     */
    public function getImageUrl($image)
    {
        return $this->getViewFileUrl('Overdose_ShoeFinder::media/' . $image);
    }

    /**
     * @return string
     */
    public function getFindingUrl()
    {
        return $this->getUrl('shoe-finder/index/find');
    }

    /**
     * @return bool
     */
    public function isShowFinderTab()
    {
        return false; // temp disable until we can get it working with search spring
        $fullActionName = $this->getRequest()->getFullActionName();
        if (in_array($fullActionName, self::IGNORE_ACTIONS)) {
            return false;    
        }
        return true;
    }
}
