define([
    'jquery',
    'matchMedia',
    'mage/collapsible'
], function ($, mediaCheck) {
    'use strict';

    $.widget('mage.mobileAccordion', {
        options: {
            openedState: 'active',
            collapsible: true,
            active: false
        },

        _create: function () {
            const self = this;

            console.log('mobileAccordion');

            mediaCheck({
                media: '(max-width: 768px)',
                entry: function () {
                    self._initAccordion();
                },
                exit: function () {
                    self._destroyAccordion();
                }
            });
        },

        _initAccordion: function () {
            if (!this.element.hasClass('initialized')) {
                this.element.find('[data-role="collapsible"]').collapsible(this.options);
                this.element.addClass('initialized');
            }
        },

        _destroyAccordion: function () {
            if (this.element.hasClass('initialized')) {
                this.element.find('[data-role="collapsible"]').collapsible('destroy');
                this.element.find('[data-role="content"]').show(); // ← додано
                this.element.removeClass('initialized');
            }
        }
    });

    return $.mage.mobileAccordion;
});
