define([
    'jquery',
    'Magento_Customer/js/customer-data',
    'underscore'
], function ($, customerData, _) {
    'use strict';

    var minicartItemMixin = {

        /**
         * Load saleable quantity
         */
        qtyOptions: function (itemId) {
            var maxQty = this.getMaxQty(itemId);
            var options = [];

            for (var i = 1; i <= maxQty; i++) {
                options.push(i);
            }

            return options;
        },

        /**
         * Get maximum quantity available
         * Check product's saleable qty but cap at 10
         */
        getMaxQty: function (itemId) {
            var cartData = customerData.get('cart')();
            var maxQty = 10;

            if (cartData && cartData.items) {
                var item = _.find(cartData.items, function (cartItem) {
                    return cartItem.item_id == itemId;
                });

                if (item && item.qty_available) {
                    maxQty = Math.min(parseInt(item.qty_available), 10);
                }
            }

            return maxQty;
        },

        /**
         * Handle quantity change
         */
        handleQtyChange: function (item, event) {
            var itemId = item.item_id;

            // Update the input field
            $('#cart-item-' + itemId + '-qty').val(parseInt(event.target.value));

            var updateButton = $('#update-cart-item-' + itemId);
            localStorage.removeItem('shipping_message');
            localStorage.removeItem('shipping_price');
            localStorage.removeItem('grand_total');
            updateButton.trigger('click');
        }
    };

    return function (target) {
        return target.extend(minicartItemMixin);
    };
});