define([
    'jquery',
    'ko',
    'uiComponent',
    'Magento_Checkout/js/model/totals',
    'mage/validation'
], function ($, ko, Component, totals) {
    'use strict';

    return function (uiComponent) {
        return uiComponent.extend({
            defaults: {
                inputText: ko.observable('Enter the gift card code'),
                giftCartCode: ko.observable(''),
            },

            /** @inheritdoc */
            initObservable: function () {
                this._super();

                return this;
            },

            /**
             * Cancel using giftcard
             */
            cancel: function () {
                if (this.validate()) {
                    $('.totals.giftcard .action').trigger('click');
                }
                this.giftCartCode('');
            },

            /**
             * @override
             *
             * @returns {bool}
             */
            isAvailable: function () {
                if (totals.getSegment('giftcardaccount') && totals.getSegment('giftcardaccount').value !== 0) {
                    let jsonCarts = totals.getSegment('giftcardaccount').extension_attributes.gift_cards;
                    let objCarts = JSON.parse(jsonCarts);
                    this.giftCartCode(objCarts[0].c);
                    return this;
                }
            }
        });
    };
});
