define([
    'underscore',
    'jquery',
    'uiRegistry',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/checkout-data',
    'Magento_Checkout/js/model/step-navigator',
    'Magento_InventoryInStorePickupFrontend/js/model/pickup-locations-service',
    'Magento_Checkout/js/model/checkout-data-resolver',
    'Magento_Checkout/js/action/select-shipping-address',    
    'Magento_Checkout/js/model/shipping-rates-validator',
    'Magento_Checkout/js/model/address-converter'
], function (
    _,
    $,
    registry,
    quote,
    checkoutData,
    stepNavigator,
    pickupLocationsService,
    checkoutDataResolver,
    selectShippingAddress,
    shippingRatesValidator,
    addressConverter
) {
    'use strict';

    var mixin = {

        /**
         * Synchronize store pickup visibility with shipping step.
         *
         * @returns void
         */
        syncWithShipping: function () {
            var shippingStep = _.findWhere(stepNavigator.steps(), {
                code: 'shipping'
            });

            // <custom>
            if (shippingStep == undefined) {
                this.isVisible(false);
                return;
            }
            // </custom>

            shippingStep.isVisible.subscribe(function (isShippingVisible) {
                this.isVisible(this.isAvailable && isShippingVisible);
            }, this);
            this.isVisible(this.isAvailable && shippingStep.isVisible());
        },

        buttonText: function () {
            if (window.checkoutConfig.overdoseInStorePickup && window.checkoutConfig.overdoseInStorePickup.is_available_method) {
                return 'Click & Collect';
            } else {
                return 'Click & Collect (Unavailable)';
            }
        },

        isDisableCC: function ()  {
            if (window.checkoutConfig.overdoseInStorePickup && window.checkoutConfig.overdoseInStorePickup.is_available_method) {
                $('.action-select-store-pickup').removeAttr('disabled');
            } else {
                $('.action-select-store-pickup').attr('disabled', true);
            }
        },

        /** @inheritdoc */
        preselectLocation: function () {
            var selectedLocation,
                shippingAddress,
                customAttributes,
                selectedSourceCode,
                nearestLocation,
                productsInfo = [],
                items = quote.getItems();

            if (!this.isStorePickupSelected()) {
                return;
            }

            selectedLocation = pickupLocationsService.selectedLocation();

            if (selectedLocation) {
                pickupLocationsService.selectForShipping(selectedLocation);
                return;
            }

            shippingAddress = quote.shippingAddress();
            customAttributes = shippingAddress.customAttributes || [];
            selectedSourceCode = _.findWhere(customAttributes, {
                'attribute_code': 'sourceCode'
            });

            if (selectedSourceCode) {
                pickupLocationsService
                    .getLocation(selectedSourceCode.value)
                    .then(function (location) {
                        pickupLocationsService.selectForShipping(location);
                    });
                // <custom>
            } else {
                // </custom>
                _.each(items, function (item) {
                    if (item['qty_options'] === undefined || item['qty_options'].length === 0) {
                        productsInfo.push(
                            {
                                sku: item.sku
                            }
                        );
                    }
                });

                if (this.nearbySearchRadius) {
                    pickupLocationsService
                        .getNearbyLocations({
                            area: {
                                radius: this.nearbySearchRadius,
                                searchTerm: shippingAddress.postcode + this.delimiter +
                                    shippingAddress.countryId || this.defaultCountry
                            },
                            extensionAttributes: {
                                productsInfo: productsInfo
                            },
                            pageSize: this.nearbySearchLimit
                        })
                        .then(function (locations) {
                            nearestLocation = locations[0];

                            if (nearestLocation) {
                                pickupLocationsService.selectForShipping(
                                    nearestLocation
                                );
                            }
                        });
                }
            }
        },
        
        selectStorePickup: function () {
            var pickupShippingMethod = _.findWhere(
                this.rates(),
                {
                    'carrier_code': this.rate['carrier_code'],
                    'method_code': this.rate['method_code']
                },
                this
            );
            /* Start customization */
            if (checkoutData.getSelectedShippingAddress() === null) {
                let flatData = addressConverter.formDataProviderToFlatData(
                    shippingRatesValidator.collectObservedData(),
                'shippingAddress'
                );
                window.lastNonPickUpShippingAddressInfo = addressConverter.formAddressDataToQuoteAddress(flatData);
            } else {
                window.lastNonPickUpShippingAddressInfo = null;
            }
            /* End customization */
            this.lastSelectedNonPickUpShippingAddress = checkoutData.getSelectedShippingAddress();
            checkoutData.setSelectedShippingAddress(null);
            this.preselectLocation();
            this.selectShippingMethod(pickupShippingMethod);
        },
        
        selectShipping: function() {
            var nonPickupShippingMethod = _.find(this.rates(), function(rate) {
                return (rate['carrier_code'] !== this.rate['carrier_code'] && rate['method_code'] !== this.rate['method_code']);
            }, this), nonPickupShippingAddress;
            checkoutData.setSelectedShippingAddress(this.lastSelectedNonPickUpShippingAddress);
            this.selectShippingMethod(nonPickupShippingMethod);
            if (this.isStorePickupAddress(quote.shippingAddress())) {
                nonPickupShippingAddress = checkoutDataResolver.getShippingAddressFromCustomerAddressList();
                if (nonPickupShippingAddress) {
                    selectShippingAddress(nonPickupShippingAddress);
                } else if (window.lastNonPickUpShippingAddressInfo) {
                    selectShippingAddress(window.lastNonPickUpShippingAddressInfo);
                }
            }
            quote.shippingMethod(null)
            this.selectShippingMethod(null);
        },
    };

    return function (target) {
        return target.extend(mixin);
    };
});
