define([
    'ko',
    'uiComponent',
    'Magento_Customer/js/customer-data'
], function (ko, Component, customerData) {
    'use strict';

    return Component.extend({
        displaySubtotal: ko.observable(true),
        grandTotal: ko.observable(false),

        /**
         * @override
         */
        initialize: function () {
            this._super();
            this.cart = customerData.get('cart');
            this.getGrandTotal();
        },

        getGrandTotal: function () {
            if (customerData.get('cart').grand_total) {
                this.grandTotal(true);
            }
        }
    });
});
