define([
    'jquery',
    'Magento_Checkout/js/view/summary/item/details/subtotal'
], function($, subtotal){
'use strict';
    var quoteItemData = window.checkoutConfig.quoteItemData;

    var mixin = {
        quoteItemData: quoteItemData,
        getItem: function(item_id) {
            var itemElement = null;
            _.each(this.quoteItemData, function(element, index) {
                if (element.item_id == item_id) {
                    itemElement = element;
                }
            });
            return itemElement;
        },
        isSpecialPricePresent: function(quoteItem){
            var item = this.getItem(quoteItem.item_id);
            var originalPrice = parseFloat(item.base_original_price,10);
            var price = item.base_calculation_price;

            return this.getFormattedPrice(originalPrice) !== this.getFormattedPrice(price);
        },
        getOriginalPrice: function(quoteItem){
            var item = this.getItem(quoteItem.item_id);
            var originalPrice = parseFloat(item.base_original_price,10);

            return this.getFormattedPrice(originalPrice);
        },
    };

    return function (target) {
        return target.extend(mixin);
    };

});
