define([
    'jquery',
    'Magento_Checkout/js/model/quote'
], function ($, quote) {
    'use strict';
    return function (Component) {
        return Component.extend({
            initialize: function () {
                var self = this;
                return this._super();
            },
            /**
             * @return {*}
             */
            getIncludingValue: function () {
                if (!quote.shippingMethod()) {
                    localStorage.setItem('shipping_message','Calculated at Checkout');
                    return 'Calculated at Checkout';
                }

                var price;

                if (!this.isCalculated()) {
                    localStorage.setItem('shipping_message', this.notCalculatedMessage);
                    return this.notCalculatedMessage;
                }
                price = this.totals()['shipping_incl_tax'];

                if (price == 0) {
                    localStorage.setItem('shipping_message', 'FREE');
                    return 'FREE';
                }
                else {
                    localStorage.setItem('shipping_message', this.getFormattedPrice(price));
                    localStorage.setItem('shipping_price', price);
                    localStorage.setItem('grand_total', this.getFormattedPrice(this.totals()['grand_total']));
                    return this.getFormattedPrice(price);
                }
            },

            /**
             * @return {*}
             */
            getExcludingValue: function () {
                if (!quote.shippingMethod()) {
                    localStorage.setItem('shipping_message','Calculated at Checkout');
                    return 'Calculated at Checkout';
                }
                var price;

                if (!this.isCalculated()) {
                    localStorage.setItem('shipping_message', this.notCalculatedMessage);
                    return this.notCalculatedMessage;
                }
                price = this.totals()['shipping_amount'];

                if (price == 0) {
                    localStorage.setItem('shipping_message', 'FREE');
                    return 'FREE';
                }
                else {
                    localStorage.setItem('shipping_message', this.getFormattedPrice(price));
                    localStorage.setItem('shipping_price', price);
                    localStorage.setItem('grand_total', this.getFormattedPrice(this.totals()['grand_total']));
                    return this.getFormattedPrice(price);
                }
            }
        });
    }
});
