<?php
return [
    'scopes' => [
        'websites' => [
            'admin' => [
                'website_id' => '0',
                'code' => 'admin',
                'name' => 'Admin',
                'sort_order' => '0',
                'default_group_id' => '0',
                'is_default' => '0'
            ],
            'asics_web' => [
                'website_id' => '2',
                'code' => 'asics_web',
                'name' => 'Asics Website',
                'sort_order' => '0',
                'default_group_id' => '2',
                'is_default' => '1'
            ]
        ],
        'groups' => [
            0 => [
                'group_id' => '0',
                'website_id' => '0',
                'name' => 'Default',
                'root_category_id' => '0',
                'default_store_id' => '0',
                'code' => 'default'
            ],
            2 => [
                'group_id' => '2',
                'website_id' => '2',
                'name' => 'Asics Website Store',
                'root_category_id' => '2',
                'default_store_id' => '2',
                'code' => 'asics_store'
            ]
        ],
        'stores' => [
            'admin' => [
                'store_id' => '0',
                'code' => 'admin',
                'website_id' => '0',
                'group_id' => '0',
                'name' => 'Admin',
                'sort_order' => '0',
                'is_active' => '1'
            ],
            'asics_view' => [
                'store_id' => '2',
                'code' => 'asics_view',
                'website_id' => '2',
                'group_id' => '2',
                'name' => 'Asics Store View',
                'sort_order' => '0',
                'is_active' => '1'
            ]
        ]
    ],
    'system' => [
        'default' => [
            'general' => [
                'locale' => [
                    'code' => 'en_NZ'
                ]
            ],
            'dev' => [
                'static' => [
                    'sign' => '1'
                ],
                'template' => [
                    'minify_html' => '0'
                ],
                'js' => [
                    'merge_files' => '0',
                    'minify_files' => '1',
                    'enable_magepack_js_bundling' => '0',
                    'minify_exclude' => [
                        'tiny_mce' => '/tiny_mce/',
                        'cardinal_commerce' => '/v1/songbird'
                    ],
                    'move_script_to_bottom' => '1',
                    'session_storage_logging' => '0',
                    'translate_strategy' => 'dictionary'
                ],
                'css' => [
                    'minify_files' => '1',
                    'merge_css_files' => '0',
                    'minify_exclude' => [
                        'tiny_mce' => '/tiny_mce/'
                    ],
                    'use_css_critical_path' => '0'
                ],
                'grid' => [
                    'async_indexing' => '1'
                ]
            ],
            'sales_email' => [
                'general' => [
                    'async_sending' => '1'
                ]
            ],
            'cataloginventory' => [
                'bulk_operations' => [
                    'async' => 1
                ]
            ]
        ],
        'stores' => [

        ],
        'websites' => [
            'asics_web' => [
                'advanced' => [
                    'modules_disable_output' => [
                        'Magento_Banner' => '1',
                        'Magento_Review' => '1',
                        'Magento_Analytics' => '1'
                    ]
                ]
            ]
        ]
    ],
    'modules' => [
        'Magento_Store' => 1,
        'Magento_Config' => 1,
        'Magento_AdminNotification' => 1,
        'Magento_AdminGwsConfigurableProduct' => 1,
        'Magento_AdminGwsStaging' => 1,
        'Magento_Directory' => 1,
        'Magento_AdobeCommerceOutOfProcessExtensibility' => 1,
        'Magento_AdobeIms' => 1,
        'Magento_AdobeIoEventsClient' => 1,
        'Magento_AdobeCommerceEventsClient' => 1,
        'Magento_AdobeImsApi' => 1,
        'Magento_AdobeCommerceEventsGenerator' => 1,
        'Magento_Theme' => 1,
        'Magento_Eav' => 1,
        'Magento_AdvancedPricingImportExport' => 1,
        'Magento_Rule' => 1,
        'Magento_Customer' => 1,
        'Magento_Backend' => 1,
        'Magento_Amqp' => 1,
        'Magento_Security' => 1,
        'Magento_Indexer' => 1,
        'Magento_User' => 1,
        'Magento_Authorization' => 1,
        'Magento_Variable' => 1,
        'Magento_AwsS3CustomerCustomAttributes' => 1,
        'Magento_GiftCardImportExport' => 1,
        'Magento_Cms' => 1,
        'Magento_ImportExport' => 1,
        'Magento_AdminAdobeIms' => 1,
        'Magento_Backup' => 1,
        'Magento_Catalog' => 1,
        'Magento_Payment' => 1,
        'Magento_Quote' => 1,
        'Magento_SalesSequence' => 1,
        'Magento_Sales' => 1,
        'Magento_Bundle' => 1,
        'Magento_BundleImportExport' => 1,
        'Magento_BundleImportExportStaging' => 1,
        'Magento_CatalogInventory' => 1,
        'Magento_CacheInvalidate' => 1,
        'Magento_Checkout' => 1,
        'Magento_CardinalCommerce' => 1,
        'Magento_AdvancedCatalog' => 1,
        'Magento_Search' => 1,
        'Magento_CatalogImportExport' => 1,
        'Magento_CatalogImportExportStaging' => 1,
        'Magento_SalesArchive' => 1,
        'Magento_CatalogRule' => 1,
        'Magento_CatalogPageBuilderAnalytics' => 1,
        'Magento_CatalogPageBuilderAnalyticsStaging' => 1,
        'Magento_CatalogUrlRewrite' => 1,
        'Magento_CustomerCustomAttributes' => 1,
        'Magento_Msrp' => 1,
        'Magento_SalesRule' => 1,
        'Magento_Captcha' => 1,
        'Magento_Downloadable' => 1,
        'Magento_MediaStorage' => 1,
        'Magento_GiftCard' => 1,
        'Magento_Wishlist' => 1,
        'Magento_Robots' => 1,
        'Magento_CatalogEvent' => 1,
        'Magento_Ui' => 1,
        'Magento_CheckoutAddressSearch' => 1,
        'Magento_CheckoutAgreements' => 1,
        'Magento_Staging' => 1,
        'Magento_CloudComponents' => 1,
        'Magento_AdvancedCheckout' => 1,
        'Magento_CmsPageBuilderAnalytics' => 1,
        'Magento_CmsPageBuilderAnalyticsStaging' => 1,
        'Magento_Widget' => 1,
        'Magento_CmsUrlRewrite' => 1,
        'Magento_Integration' => 1,
        'Magento_ConfigurableProduct' => 1,
        'Magento_CatalogRuleConfigurable' => 1,
        'Magento_ConfigurableProductSales' => 1,
        'Magento_PageCache' => 1,
        'Magento_Contact' => 1,
        'Magento_Cookie' => 1,
        'Magento_Cron' => 1,
        'Magento_Csp' => 1,
        'Magento_CurrencySymbol' => 1,
        'Magento_CustomAttributeManagement' => 1,
        'Magento_AdvancedRule' => 1,
        'Magento_CustomerBalance' => 1,
        'Magento_CustomerSegment' => 1,
        'Magento_CustomerImportExport' => 1,
        'Magento_CatalogWidget' => 1,
        'Magento_DeferredTotalCalculating' => 1,
        'Magento_Deploy' => 1,
        'Magento_Developer' => 1,
        'Magento_AdminGws' => 1,
        'Magento_ProductAlert' => 1,
        'Magento_CatalogSearch' => 1,
        'Magento_TargetRule' => 1,
        'Magento_AdvancedSearch' => 1,
        'Magento_Elasticsearch' => 1,
        'Magento_WebsiteRestriction' => 1,
        'Magento_Email' => 1,
        'Magento_EncryptionKey' => 1,
        'Magento_Enterprise' => 1,
        'Magento_Tax' => 1,
        'Magento_GiftCardAccount' => 1,
        'Magento_Sitemap' => 1,
        'Magento_VisualMerchandiser' => 1,
        'Magento_GiftMessage' => 1,
        'Magento_GiftMessageStaging' => 1,
        'Magento_CatalogPermissions' => 1,
        'Magento_GiftWrapping' => 1,
        'Magento_GiftWrappingStaging' => 1,
        'Magento_GoogleAdwords' => 1,
        'Magento_GoogleAnalytics' => 1,
        'Magento_GoogleGtag' => 1,
        'Magento_GoogleShoppingAds' => 1,
        'Magento_VersionsCms' => 1,
        'Magento_GroupedProduct' => 1,
        'Magento_GroupedImportExport' => 1,
        'Magento_GroupedCatalogInventory' => 1,
        'Magento_Weee' => 1,
        'Magento_ImportCsv' => 1,
        'Magento_ImportCsvApi' => 1,
        'Magento_RemoteStorage' => 1,
        'Magento_AwsS3' => 1,
        'Magento_InstantPurchase' => 1,
        'Magento_Analytics' => 1,
        'Magento_Inventory' => 1,
        'Magento_InventoryAdminUi' => 1,
        'Magento_InventoryApi' => 1,
        'Magento_InventoryBundleImportExport' => 1,
        'Magento_InventoryBundleProduct' => 1,
        'Magento_InventoryBundleProductAdminUi' => 1,
        'Magento_InventoryBundleProductIndexer' => 1,
        'Magento_InventoryCatalog' => 1,
        'Magento_InventorySales' => 1,
        'Magento_InventoryCatalogAdminUi' => 1,
        'Magento_InventoryCatalogApi' => 1,
        'Magento_InventoryCatalogFrontendUi' => 1,
        'Magento_InventoryCatalogSearch' => 1,
        'Magento_InventoryCatalogSearchBundleProduct' => 1,
        'Magento_InventoryCatalogSearchConfigurableProduct' => 1,
        'Magento_InventoryConfigurableProduct' => 1,
        'Magento_InventoryConfigurableProductAdminUi' => 1,
        'Magento_InventoryConfigurableProductFrontendUi' => 1,
        'Magento_InventoryConfigurableProductIndexer' => 1,
        'Magento_InventoryConfiguration' => 1,
        'Magento_InventoryConfigurationApi' => 1,
        'Magento_InventoryDistanceBasedSourceSelection' => 1,
        'Magento_InventoryDistanceBasedSourceSelectionAdminUi' => 1,
        'Magento_InventoryDistanceBasedSourceSelectionApi' => 1,
        'Magento_InventoryElasticsearch' => 1,
        'Magento_InventoryExportStockApi' => 1,
        'Magento_InventoryGroupedProduct' => 1,
        'Magento_InventoryGroupedProductAdminUi' => 1,
        'Magento_InventoryGroupedProductIndexer' => 1,
        'Magento_InventoryImportExport' => 1,
        'Magento_InventoryInStorePickupApi' => 1,
        'Magento_InventoryInStorePickupAdminUi' => 1,
        'Magento_InventorySalesApi' => 1,
        'Magento_InventorySourceSelectionApi' => 1,
        'Magento_Shipping' => 1,
        'Magento_InventoryInStorePickupShippingApi' => 1,
        'Magento_InventoryInStorePickupSales' => 1,
        'Magento_InventoryInStorePickupSalesApi' => 1,
        'Magento_InventoryInStorePickupQuote' => 1,
        'Magento_InventoryInStorePickupShipping' => 1,
        'Magento_InventoryInStorePickupShippingAdminUi' => 1,
        'Magento_Multishipping' => 1,
        'Magento_Webapi' => 1,
        'Magento_InventoryIndexer' => 1,
        'Magento_InventoryLowQuantityNotification' => 1,
        'Magento_Reports' => 1,
        'Magento_InventoryLowQuantityNotificationApi' => 1,
        'Magento_InventoryMultiDimensionalIndexerApi' => 1,
        'Magento_InventoryProductAlert' => 1,
        'Magento_InventoryRequisitionList' => 1,
        'Magento_InventoryReservations' => 1,
        'Magento_InventoryReservationsApi' => 1,
        'Magento_InventoryCache' => 1,
        'Magento_InventorySalesAdminUi' => 1,
        'Magento_InventoryInStorePickup' => 1,
        'Magento_InventorySalesAsyncOrder' => 1,
        'Magento_InventorySalesFrontendUi' => 1,
        'Magento_InventorySetupFixtureGenerator' => 1,
        'Magento_InventoryShipping' => 1,
        'Magento_InventoryShippingAdminUi' => 1,
        'Magento_InventorySourceDeductionApi' => 1,
        'Magento_InventorySourceSelection' => 1,
        'Magento_InventoryInStorePickupFrontend' => 1,
        'Magento_InventorySwatchesFrontendUi' => 1,
        'Magento_InventoryVisualMerchandiser' => 1,
        'Magento_InventoryWishlist' => 1,
        'Magento_Invitation' => 1,
        'Magento_JwtFrameworkAdapter' => 1,
        'Magento_JwtUserToken' => 1,
        'Magento_LayeredNavigation' => 1,
        'Magento_LayeredNavigationStaging' => 1,
        'Magento_Logging' => 1,
        'Magento_LoginAsCustomer' => 1,
        'Magento_LoginAsCustomerAdminUi' => 1,
        'Magento_LoginAsCustomerApi' => 1,
        'Magento_LoginAsCustomerAssistance' => 1,
        'Magento_LoginAsCustomerFrontendUi' => 1,
        'Magento_LoginAsCustomerLog' => 1,
        'Magento_LoginAsCustomerLogging' => 1,
        'Magento_LoginAsCustomerPageCache' => 1,
        'Magento_LoginAsCustomerQuote' => 1,
        'Magento_LoginAsCustomerSales' => 1,
        'Magento_LoginAsCustomerWebsiteRestriction' => 1,
        'Magento_MediaContent' => 1,
        'Magento_MediaContentApi' => 1,
        'Magento_MediaContentCatalog' => 1,
        'Magento_MediaContentCatalogStaging' => 1,
        'Magento_MediaContentCms' => 1,
        'Magento_MediaContentSynchronization' => 1,
        'Magento_MediaContentSynchronizationApi' => 1,
        'Magento_MediaContentSynchronizationCatalog' => 1,
        'Magento_MediaContentSynchronizationCms' => 1,
        'Magento_MediaGallery' => 1,
        'Magento_MediaGalleryApi' => 1,
        'Magento_MediaGalleryCatalog' => 1,
        'Magento_MediaGalleryCatalogIntegration' => 1,
        'Magento_MediaGalleryCatalogUi' => 1,
        'Magento_MediaGalleryCmsUi' => 1,
        'Magento_MediaGalleryIntegration' => 1,
        'Magento_MediaGalleryMetadata' => 1,
        'Magento_MediaGalleryMetadataApi' => 1,
        'Magento_MediaGalleryRenditions' => 1,
        'Magento_MediaGalleryRenditionsApi' => 1,
        'Magento_MediaGallerySynchronization' => 1,
        'Magento_MediaGallerySynchronizationApi' => 1,
        'Magento_MediaGallerySynchronizationMetadata' => 1,
        'Magento_MediaGalleryUi' => 1,
        'Magento_MediaGalleryUiApi' => 1,
        'Magento_GiftRegistry' => 1,
        'Magento_MessageQueue' => 1,
        'Magento_ConfigurableImportExport' => 1,
        'Magento_MsrpConfigurableProduct' => 1,
        'Magento_MsrpGroupedProduct' => 1,
        'Magento_MsrpStaging' => 1,
        'Magento_MultipleWishlist' => 1,
        'Magento_InventoryInStorePickupMultishipping' => 1,
        'Magento_MysqlMq' => 1,
        'Magento_NewRelicReporting' => 1,
        'Magento_Newsletter' => 1,
        'Magento_OfflinePayments' => 1,
        'Magento_OfflineShipping' => 1,
        'Magento_OpenSearch' => 1,
        'Magento_Banner' => 1,
        'Magento_PageBuilder' => 1,
        'Magento_PageBuilderAdminGwsAdminUi' => 1,
        'Magento_PageBuilderAnalytics' => 1,
        'Magento_CatalogStaging' => 1,
        'Magento_BannerPageBuilderAnalytics' => 1,
        'Magento_PaymentStaging' => 1,
        'Magento_Vault' => 1,
        'Magento_Paypal' => 1,
        'Magento_PaypalOnBoarding' => 1,
        'Magento_Persistent' => 1,
        'Magento_PersistentHistory' => 1,
        'Magento_PricePermissions' => 1,
        'Magento_DownloadableStaging' => 1,
        'Magento_ProductVideo' => 1,
        'Magento_ProductVideoStaging' => 1,
        'Magento_PromotionPermissions' => 1,
        'Magento_BannerCustomerSegment' => 1,
        'Magento_QuoteBundleOptions' => 1,
        'Magento_QuoteConfigurableOptions' => 1,
        'Magento_QuoteDownloadableLinks' => 1,
        'Magento_QuoteGiftCardOptions' => 1,
        'Magento_QuoteStaging' => 1,
        'Magento_ReCaptchaAdminUi' => 1,
        'Magento_ReCaptchaCheckout' => 1,
        'Magento_ReCaptchaCheckoutSalesRule' => 1,
        'Magento_ReCaptchaContact' => 1,
        'Magento_ReCaptchaCustomer' => 1,
        'Magento_ReCaptchaFrontendUi' => 1,
        'Magento_ReCaptchaGiftCard' => 1,
        'Magento_ReCaptchaInvitation' => 1,
        'Magento_ReCaptchaMigration' => 1,
        'Magento_ReCaptchaMultipleWishlist' => 1,
        'Magento_ReCaptchaNewsletter' => 1,
        'Magento_ReCaptchaPaypal' => 1,
        'Magento_ReCaptchaReview' => 1,
        'Magento_ReCaptchaSendFriend' => 1,
        'Magento_ReCaptchaStorePickup' => 1,
        'Magento_ReCaptchaUi' => 1,
        'Magento_ReCaptchaUser' => 1,
        'Magento_ReCaptchaValidation' => 1,
        'Magento_ReCaptchaValidationApi' => 1,
        'Magento_ReCaptchaVersion2Checkbox' => 1,
        'Magento_ReCaptchaVersion2Invisible' => 1,
        'Magento_ReCaptchaVersion3Invisible' => 1,
        'Magento_ReCaptchaWebapiApi' => 1,
        'Magento_ReCaptchaWebapiRest' => 1,
        'Magento_ReCaptchaWebapiUi' => 1,
        'Magento_ReCaptchaWishlist' => 1,
        'Magento_ReleaseNotification' => 1,
        'Magento_Reminder' => 1,
        'Magento_AwsS3GiftCardImportExport' => 1,
        'Magento_RemoteStorageCommerce' => 1,
        'Magento_InventoryLowQuantityNotificationAdminUi' => 1,
        'Magento_RequireJs' => 1,
        'Magento_ResourceConnections' => 1,
        'Magento_Review' => 1,
        'Magento_Rma' => 1,
        'Magento_RmaStaging' => 1,
        'Magento_ScheduledImportExport' => 1,
        'Magento_Rss' => 1,
        'Magento_AdvancedSalesRule' => 1,
        'Magento_BannerStaging' => 1,
        'Magento_AsyncOrder' => 1,
        'Magento_SalesInventory' => 1,
        'Magento_CatalogRuleStaging' => 1,
        'Magento_SalesRuleStaging' => 1,
        'Magento_GoogleTagManager' => 1,
        'Magento_ScalableCheckout' => 1,
        'Magento_ScalableInventory' => 1,
        'Magento_ScalableOms' => 1,
        'Magento_AwsS3ScheduledImportExport' => 1,
        'Magento_Elasticsearch7' => 1,
        'Magento_SearchStaging' => 1,
        'Magento_TwoFactorAuth' => 0,
        'Magento_Securitytxt' => 1,
        'Magento_SendFriend' => 1,
        'Magento_InventoryInStorePickupSalesAdminUi' => 1,
        'Magento_AwsS3PageBuilder' => 1,
        'Magento_CheckoutStaging' => 1,
        'Magento_StagingPageBuilder' => 1,
        'Magento_CatalogInventoryStaging' => 1,
        'Magento_Support' => 1,
        'Magento_Swagger' => 1,
        'Magento_SwaggerWebapi' => 1,
        'Magento_SwaggerWebapiAsync' => 1,
        'Magento_Swat' => 1,
        'Magento_Swatches' => 1,
        'Magento_SwatchesLayeredNavigation' => 1,
        'Magento_UrlRewrite' => 1,
        'Magento_GiftCardStaging' => 1,
        'Magento_TaxImportExport' => 1,
        'Magento_PageBuilderAdminAnalytics' => 1,
        'Magento_Translation' => 1,
        'Magento_AdminAdobeImsTwoFactorAuth' => 0,
        'Magento_CheckoutAddressSearchGiftRegistry' => 1,
        'Magento_CatalogUrlRewriteStaging' => 1,
        'Magento_AsynchronousOperations' => 1,
        'Magento_ElasticsearchCatalogPermissions' => 1,
        'Magento_PaypalCaptcha' => 1,
        'Magento_CmsStaging' => 1,
        'Magento_VersionsCmsPageCache' => 1,
        'Magento_VersionsCmsUrlRewrite' => 1,
        'Magento_BundleStaging' => 1,
        'Magento_InventoryInStorePickupWebapiExtension' => 1,
        'Magento_WebapiAsync' => 1,
        'Magento_WebapiSecurity' => 1,
        'Magento_GroupedProductStaging' => 1,
        'Magento_ConfigurableProductStaging' => 1,
        'Magento_WeeeStaging' => 1,
        'Magento_BannerPageBuilder' => 1,
        'Magento_CatalogStagingPageBuilder' => 1,
        'Magento_WishlistGiftCard' => 1,
        'Afterpay_Afterpay' => 1,
        'Amasty_BannersLite' => 1,
        'Amasty_Base' => 1,
        'Amasty_Geoip' => 1,
        'Amasty_Rgrid' => 1,
        'Amasty_Rules' => 1,
        'Amasty_RulesPro' => 1,
        'Amasty_ShopbyBase' => 1,
        'Amasty_Shopby' => 1,
        'Amasty_ShopbyBrand' => 1,
        'Amasty_ShopbyPage' => 1,
        'Amasty_ShopbySeo' => 1,
        'Amasty_Storelocator' => 1,
        'Anowave_Package' => 1,
        'Anowave_Ec' => 1,
        'Anowave_Ec4' => 1,
        'Apptrian_FacebookPixel' => 1,
        'Asics_Analytics' => 1,
        'Asics_App' => 1,
        'Asics_Checkout' => 1,
        'Asics_CustomPatch' => 1,
        'Verifone_Hosted' => 1,
        'Windcave_Payments' => 1,
        'Asicspagebuilder_PageBuilderBanner' => 1,
        'Asicspagebuilder_PageBuilderCategorytiles' => 1,
        'Asicspagebuilder_PageBuilderExtensionButtonItem' => 1,
        'Asicspagebuilder_PageBuilderExtensionButtons' => 1,
        'Asicspagebuilder_PageBuilderExtensionRow' => 1,
        'Asicspagebuilder_PageBuilderExtensionSlider' => 1,
        'Asicspagebuilder_PageBuilderFaq' => 1,
        'Asicspagebuilder_PageBuilderLargearticletile' => 1,
        'Asicspagebuilder_PageBuilderLargecategorytile' => 1,
        'Asicspagebuilder_PageBuilderLargecategorytiles' => 1,
        'Asicspagebuilder_PageBuilderMegamenuimageblock' => 1,
        'Asicspagebuilder_PageBuilderPicked' => 1,
        'Asicspagebuilder_PageBuilderProducttiles' => 1,
        'Asicspagebuilder_PageBuilderSmallarticletiles' => 1,
        'Bazaarvoice_Connector' => 1,
        'BrittainWynyard_Ajaxnewsletter' => 1,
        'Mirasvit_SeoMarkup' => 1,
        'BrittainWynyard_Breadcrumbs' => 1,
        'BrittainWynyard_CatalogAttributes' => 1,
        'BrittainWynyard_CatalogSuperStyle' => 1,
        'BrittainWynyard_CheckoutAttributes' => 1,
        'BrittainWynyard_Content' => 1,
        'BrittainWynyard_Csp' => 1,
        'BrittainWynyard_Customersession' => 1,
        'Fastly_Cdn' => 1,
        'BrittainWynyard_GoogleTagManager' => 1,
        'BrittainWynyard_MinicartAutoopen' => 1,
        'BrittainWynyard_OneAsics' => 1,
        'BrittainWynyard_Payments' => 1,
        'BrittainWynyard_RecentlyViewedWidget' => 1,
        'BrittainWynyard_ResolveConflicts' => 1,
        'BrittainWynyard_Sales' => 1,
        'BrittainWynyard_Searchspring' => 1,
        'BrittainWynyard_StoreLocator' => 1,
        'BrittainWynyard_WysiwygDownloads' => 1,
        'Bss_LazyImageLoader' => 1,
        'Bss_Quickview' => 1,
        'EightWire_CourierPost' => 1,
        'EightWire_CronHealth' => 1,
        'EightWire_DisableNewsletterEmail' => 1,
        'EightWire_Fliway' => 1,
        'EightWire_LogRocket' => 1,
        'EightWire_NewZealandDirectory' => 1,
        'EightWire_SuperStyleSwatch' => 1,
        'EthanYehuda_CronjobManager' => 1,
        'BrittainWynyard_Fastly' => 1,
        'Gene_EncryptionKeyManager' => 1,
        'Klaviyo_Reclaim' => 1,
        'MageSuite_Magepack' => 1,
        'Magefan_AdminUserGuide' => 1,
        'Magefan_Community' => 1,
        'Magefan_LazyLoad' => 1,
        'Mageplaza_Core' => 1,
        'Mageplaza_ImportExportCategories' => 1,
        'Mageplaza_Smtp' => 1,
        'Mirasvit_Core' => 1,
        'Mirasvit_Seo' => 1,
        'Mirasvit_SeoAi' => 1,
        'Mirasvit_SeoAudit' => 0,
        'Mirasvit_SeoAutolink' => 1,
        'Mirasvit_SeoContent' => 1,
        'Mirasvit_SeoFilter' => 1,
        'BrittainWynyard_BazaarVoice' => 1,
        'Mirasvit_SeoSitemap' => 1,
        'Mirasvit_SeoToolbar' => 1,
        'OlegKoval_RegenerateUrlRewrites' => 1,
        'Overdose_AddressValidation' => 1,
        'Overdose_Afterpay' => 1,
        'Overdose_AmStoreLocatorExport' => 1,
        'Overdose_Theme' => 1,
        'Overdose_BssLazyLoad' => 1,
        'Overdose_CMSContent' => 1,
        'Overdose_Cart' => 1,
        'Overdose_Catalog' => 1,
        'Overdose_CatalogAttribute' => 1,
        'Overdose_CatalogSortToolbar' => 1,
        'Overdose_Checkout' => 1,
        'Overdose_CheckoutInputPlaceholder' => 1,
        'Overdose_CheckoutSuccess' => 1,
        'Overdose_Core' => 1,
        'Overdose_CustomCMSContent' => 1,
        'Overdose_CustomDataEmails' => 1,
        'Overdose_Customer' => 1,
        'Overdose_DataLayer' => 1,
        'Overdose_EcoShipping' => 1,
        'Overdose_ExpressShipping' => 1,
        'Overdose_GiftCardAccountApi' => 1,
        'Overdose_InStorePickup' => 1,
        'Overdose_InventoryShipping' => 1,
        'Overdose_Klaviyo' => 1,
        'Overdose_LazyLoadJavascript' => 1,
        'Overdose_LiveChat' => 0,
        'Overdose_MagefunLazyLoad' => 1,
        'Overdose_MultiSelectSwatch' => 1,
        'Overdose_NotificationBar' => 1,
        'Overdose_OrderComment' => 1,
        'Overdose_ProductBanners' => 1,
        'Overdose_Quote' => 1,
        'Overdose_RelatedCategories' => 1,
        'Overdose_SafeProduction' => 1,
        'Overdose_Sales' => 1,
        'Overdose_Seo' => 1,
        'Overdose_ShoeFinder' => 1,
        'Snowdog_Menu' => 1,
        'Overdose_StoreInformation' => 1,
        'Overdose_Base' => 0,
        'Overdose_UrlSubpath' => 1,
        'PayPal_Braintree' => 0,
        'SearchSpring_Feed' => 1,
        'Searchspring_Tracking' => 1,
        'Overdose_SnowdogMenu' => 1,
        'Asics_Verifone' => 1,
        'Asics_Windcave' => 1,
        'Xtento_XtCore' => 1,
        'Xtento_ProductExport' => 1
    ],
    'admin_user' => [
        'locale' => [
            'code' => [
                'en_NZ'
            ]
        ]
    ]
];
