#!/bin/sh
# 1) dump production DB (run on Prod server): mysqldump -h <database host> --user=<database username> --password=<password> --single-transaction <database name>  | sed -e 's/DEFINER[ ]*=[ ]*[^*]*\*/\*/' | gzip > var/db.sql.gz
# 2) copy dump to staging (run on Staging server): scp 1.ent-v7jcmstnrgvqq-production-vohbr3y@ssh.ap-3.magento.cloud:var/db.sql.gz var/db.sql.gz
# 3) run this script: ./dev/update_staging_db.sh

# Staging variables
BASE_URL="mcstaging.britwyn.co.nz"

# import DB from file
./magerun2.phar db:drop
./magerun2.phar db:create
./magerun2.phar db:import --compression="gzip" var/db.sql.gz

# update configs for staging
./magerun2.phar config:store:set --scope="default"  --scope-id="0" "web/unsecure/base_url" "https://$BASE_URL/"
./magerun2.phar config:store:set --scope="default"  --scope-id="0" "web/secure/base_url"   "https://$BASE_URL/"
./magerun2.phar config:store:set --scope="websites"  --scope-id="2" "web/unsecure/base_url" "https://$BASE_URL/nz/en-nz/"
./magerun2.phar config:store:set --scope="websites"  --scope-id="2" "web/secure/base_url"   "https://$BASE_URL/nz/en-nz/"

./magerun2.phar config:store:set --scope="default" --scope-id="0" "oneasics/oauth/client_secret" "XX7nSdg0RYrsBBoUpC6WfaSxqyYRjL52"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/stripe_payments_express/apple_pay_checkout" "1"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/stripe_payments_express/cart_button" "1"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/stripe_payments_express/product_button" "1"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/stripe_payments_express/minicart" "1"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/stripe_payments_express/button_type" "buy"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/checkmo/active" "1"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/checkmo/sort_order" "100"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/paymentexpress_pxfusion/postUrl" "https://uat.windcave.com/pxmi3/pxfusionauth"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/paymentexpress_pxfusion/wsdl" "https://uat.windcave.com/pxf/pxf.svc?wsdl"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/afterpaypayovertime/api_mode" "sandbox"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/afterpaypayovertime/merchant_id" "39347"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "productexport/general/enabled" "0"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "klevu_search/general/js_api_key" "klevu-160184463048612752"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "klevu_search/general/rest_api_key" "a2xldnUtMTYwMTg0NDYzMDQ4NjEyNzUyOktsZXZ1LWEwc3E5MXBsZ3A="
./magerun2.phar config:store:set --scope="default" --scope-id="0" "klevu_search/general/cloud_search_url" "uscs22.ksearchnet.com"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "klevu_search/developer/collection_method" "0"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "klevu_search/attributes/automatic" "a:22:{i:0;a:2:{s:15:"klevu_attribute";s:4:"name";s:17:"magento_attribute";s:4:"name";}i:1;a:2:{s:15:"klevu_attribute";s:3:"sku";s:17:"magento_attribute";s:3:"sku";}i:2;a:2:{s:15:"klevu_attribute";s:5:"image";s:17:"magento_attribute";s:5:"image";}i:3;a:2:{s:15:"klevu_attribute";s:11:"small_image";s:17:"magento_attribute";s:11:"small_image";}i:4;a:2:{s:15:"klevu_attribute";s:13:"media_gallery";s:17:"magento_attribute";s:13:"media_gallery";}i:5;a:2:{s:15:"klevu_attribute";s:6:"status";s:17:"magento_attribute";s:6:"status";}i:6;a:2:{s:15:"klevu_attribute";s:4:"desc";s:17:"magento_attribute";s:11:"description";}i:7;a:2:{s:15:"klevu_attribute";s:9:"shortDesc";s:17:"magento_attribute";s:17:"short_description";}i:8;a:2:{s:15:"klevu_attribute";s:5:"price";s:17:"magento_attribute";s:5:"price";}i:9;a:2:{s:15:"klevu_attribute";s:9:"salePrice";s:17:"magento_attribute";s:5:"price";}i:10;a:2:{s:15:"klevu_attribute";s:9:"salePrice";s:17:"magento_attribute";s:12:"tax_class_id";}i:11;a:2:{s:15:"klevu_attribute";s:6:"weight";s:17:"magento_attribute";s:6:"weight";}i:12;a:2:{s:15:"klevu_attribute";s:6:"rating";s:17:"magento_attribute";s:6:"rating";}i:13;a:2:{s:15:"klevu_attribute";s:13:"special_price";s:17:"magento_attribute";s:13:"special_price";}i:14;a:2:{s:15:"klevu_attribute";s:17:"special_from_date";s:17:"magento_attribute";s:17:"special_from_date";}i:15;a:2:{s:15:"klevu_attribute";s:15:"special_to_date";s:17:"magento_attribute";s:15:"special_to_date";}i:16;a:2:{s:15:"klevu_attribute";s:10:"visibility";s:17:"magento_attribute";s:10:"visibility";}i:17;a:2:{s:15:"klevu_attribute";s:9:"dateAdded";s:17:"magento_attribute";s:10:"created_at";}i:18;a:2:{s:15:"klevu_attribute";s:5:"other";s:17:"magento_attribute";s:14:"asics_category";}i:19;a:2:{s:15:"klevu_attribute";s:5:"other";s:17:"magento_attribute";s:18:"asics_product_type";}i:20;a:2:{s:15:"klevu_attribute";s:5:"other";s:17:"magento_attribute";s:13:"asics_sport_1";}i:21;a:2:{s:15:"klevu_attribute";s:5:"other";s:17:"magento_attribute";s:6:"gender";}}"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "klaviyo_reclaim_general/general/private_api_key" "0:3:Za0eV62yfNSKDCvvqQnEioodfVo8hVu4F3CExLuEePEGpqJFUB6fmaURjFz926dMSOOD+D9AZvZcM1v53nnmwBk="
./magerun2.phar config:store:set --scope="default" --scope-id="0" "bazaarvoice/general/environment" "staging"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "bazaarvoice/general/client_name" "Asics-EN_AU"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "bazaarvoice/general/enable_bvpixel" "0"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "google/analytics/container_id" "GTM-KPFDDSB"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "smtp/configuration_option/password" "0:3:/Q6rhwWqQd5Gk+CXgVi5t7V3YoVjeSUqpZGCgsUgHEpYpeJXG4GI1cMciEGQdsXC+rt0yHndpWjBHZraBI20KC5tKNBz72D4zXgSkNdLHaGSlgGTvoU3JjBuSETeApEnng=="
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/windcave_pxfusion/username" "8WireDigital_Dev"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/windcave_pxfusion/password" "52a6e5eb1e8ba2e32f78080aada5702144341e020f2a131afdb7e935f9324405"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/windcave_pxfusion/postUrl" "https://uat.windcave.com/pxmi3/pxfusionauth"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/windcave_pxfusion/wsdl" "https://uat.windcave.com/pxf/pxf.svc?wsdl"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/windcave_pxfusion/pxpostusername" "8WireDigital_Dev"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/windcave_pxfusion/pxpostpassword" "52a6e5eb1e8ba2e32f78080aada5702144341e020f2a131afdb7e935f9324405"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "payment/windcave_pxfusion/pxposturl" "https://uat.paymentexpress.com/pxpost.aspx"
./magerun2.phar config:store:set --scope="default" --scope-id="0" "oneasics/oauth/mode" "staging"
