<?php
namespace Anowave\Ec\Helper\Data;

/**
 * Interceptor class for @see \Anowave\Ec\Helper\Data
 */
class Interceptor extends \Anowave\Ec\Helper\Data implements \Magento\Framework\Interception\InterceptorInterface
{
    use \Magento\Framework\Interception\Interceptor;

    public function __construct(\Magento\Framework\App\Helper\Context $context, \Magento\Framework\Registry $registry, \Magento\Catalog\Api\ProductRepositoryInterface $productRepository, \Magento\Catalog\Model\CategoryRepository $categoryRepository, \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory $categoryCollectionFactory, \Magento\Customer\Model\SessionFactory $sessionFactory, \Magento\Customer\Model\GroupRegistry $groupRegistry, \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory, \Magento\Sales\Model\Order\Config $orderConfig, \Magento\Framework\App\Http\Context $httpContext, \Magento\Catalog\Helper\Data $catalogData, \Magento\Catalog\Model\Product\Attribute\Repository $productAttributeRepository, \Magento\Eav\Model\ResourceModel\Entity\Attribute\Option\Collection $optionCollection, \Magento\Eav\Model\Config $eavConfig, \Anowave\Ec\Helper\Datalayer $dataLayer, \Magento\Store\Model\StoreManagerInterface $storeManager, \Magento\Framework\App\ProductMetadataInterface $productMetadata, \Magento\Framework\Module\ModuleListInterface $moduleList, \Magento\Customer\Api\CustomerRepositoryInterface $customerRepositoryInterface, \Anowave\Ec\Helper\Attributes $attributes, \Magento\Catalog\Model\ResourceModel\Eav\AttributeFactory $attribute, \Anowave\Ec\Helper\Bridge $bridge, \Magento\Framework\App\Response\RedirectInterface $redirect, \Anowave\Ec\Model\Cookie\PrivateData $privateData, \Anowave\Ec\Model\Cookie\Directive $directive, \Anowave\Ec\Helper\Json $jsonHelper, \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $salesOrderCollection, \Magento\CatalogInventory\Api\StockRegistryInterface $stockItemInterface, \Anowave\Ec\Model\Cache $cache, \Magento\Framework\UrlInterface $urlInt, \Magento\Checkout\Model\Cart $cart, \Magento\Catalog\Model\Layer\Resolver $layerResolver, \Anowave\Ec\Model\Facebook\ConversionsApiFactory $facebookConversionsApiFactory, \Magento\Framework\App\ScopeResolverInterface $scopeResolver, \Anowave\Ec\Model\Logger $logger, \Magento\Framework\Data\Form\FormKey $formKey, \Magento\Framework\Module\Manager $moduleManager, \Magento\Review\Model\ReviewFactory $reviewFactory, \Magento\Review\Model\Rating $ratingFactory, \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory, \Anowave\Ec\Model\Nonce $nonceProvider, array $data = [])
    {
        $this->___init();
        parent::__construct($context, $registry, $productRepository, $categoryRepository, $categoryCollectionFactory, $sessionFactory, $groupRegistry, $orderCollectionFactory, $orderConfig, $httpContext, $catalogData, $productAttributeRepository, $optionCollection, $eavConfig, $dataLayer, $storeManager, $productMetadata, $moduleList, $customerRepositoryInterface, $attributes, $attribute, $bridge, $redirect, $privateData, $directive, $jsonHelper, $salesOrderCollection, $stockItemInterface, $cache, $urlInt, $cart, $layerResolver, $facebookConversionsApiFactory, $scopeResolver, $logger, $formKey, $moduleManager, $reviewFactory, $ratingFactory, $productCollectionFactory, $nonceProvider, $data);
    }

    /**
     * {@inheritdoc}
     */
    public function getRevenue(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getRevenue');
        return $pluginInfo ? $this->___callPlugins('getRevenue', func_get_args(), $pluginInfo) : parent::getRevenue($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getRevenueProduct(\Magento\Sales\Model\Order\Item $item)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getRevenueProduct');
        return $pluginInfo ? $this->___callPlugins('getRevenueProduct', func_get_args(), $pluginInfo) : parent::getRevenueProduct($item);
    }

    /**
     * {@inheritdoc}
     */
    public function getRevenueAdWords(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getRevenueAdWords');
        return $pluginInfo ? $this->___callPlugins('getRevenueAdWords', func_get_args(), $pluginInfo) : parent::getRevenueAdWords($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getCheckoutPush($block, \Magento\Framework\Registry $registry)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCheckoutPush');
        return $pluginInfo ? $this->___callPlugins('getCheckoutPush', func_get_args(), $pluginInfo) : parent::getCheckoutPush($block, $registry);
    }

    /**
     * {@inheritdoc}
     */
    public function getMultiCheckoutPush(\Anowave\Ec\Block\Track $block, $step)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getMultiCheckoutPush');
        return $pluginInfo ? $this->___callPlugins('getMultiCheckoutPush', func_get_args(), $pluginInfo) : parent::getMultiCheckoutPush($block, $step);
    }

    /**
     * {@inheritdoc}
     */
    public function getCartPush($block, \Magento\Framework\Registry $registry)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCartPush');
        return $pluginInfo ? $this->___callPlugins('getCartPush', func_get_args(), $pluginInfo) : parent::getCartPush($block, $registry);
    }

    /**
     * {@inheritdoc}
     */
    public function getCheckoutProducts($block, \Magento\Framework\Registry $registry)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCheckoutProducts');
        return $pluginInfo ? $this->___callPlugins('getCheckoutProducts', func_get_args(), $pluginInfo) : parent::getCheckoutProducts($block, $registry);
    }

    /**
     * {@inheritdoc}
     */
    public function getDetailPushForward($block)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getDetailPushForward');
        return $pluginInfo ? $this->___callPlugins('getDetailPushForward', func_get_args(), $pluginInfo) : parent::getDetailPushForward($block);
    }

    /**
     * {@inheritdoc}
     */
    public function getDetailGroup(\Magento\Catalog\Block\Product\View $block, \Magento\Catalog\Model\Category $category)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getDetailGroup');
        return $pluginInfo ? $this->___callPlugins('getDetailGroup', func_get_args(), $pluginInfo) : parent::getDetailGroup($block, $category);
    }

    /**
     * {@inheritdoc}
     */
    public function getPurchasePayloadCollection($block) : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getPurchasePayloadCollection');
        return $pluginInfo ? $this->___callPlugins('getPurchasePayloadCollection', func_get_args(), $pluginInfo) : parent::getPurchasePayloadCollection($block);
    }

    /**
     * {@inheritdoc}
     */
    public function getPurchasePayload($order)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getPurchasePayload');
        return $pluginInfo ? $this->___callPlugins('getPurchasePayload', func_get_args(), $pluginInfo) : parent::getPurchasePayload($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getPurchaseGoogleTagParams($block)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getPurchaseGoogleTagParams');
        return $pluginInfo ? $this->___callPlugins('getPurchaseGoogleTagParams', func_get_args(), $pluginInfo) : parent::getPurchaseGoogleTagParams($block);
    }

    /**
     * {@inheritdoc}
     */
    public function getOrders($block)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getOrders');
        return $pluginInfo ? $this->___callPlugins('getOrders', func_get_args(), $pluginInfo) : parent::getOrders($block);
    }

    /**
     * {@inheritdoc}
     */
    public function getOrdersCollection(array $order_ids = [])
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getOrdersCollection');
        return $pluginInfo ? $this->___callPlugins('getOrdersCollection', func_get_args(), $pluginInfo) : parent::getOrdersCollection($order_ids);
    }

    /**
     * {@inheritdoc}
     */
    public function getVisitorPush($block = null)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getVisitorPush');
        return $pluginInfo ? $this->___callPlugins('getVisitorPush', func_get_args(), $pluginInfo) : parent::getVisitorPush($block);
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookViewContentTrack(\Magento\Catalog\Model\Product $product, \Magento\Catalog\Model\Category $category)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookViewContentTrack');
        return $pluginInfo ? $this->___callPlugins('getFacebookViewContentTrack', func_get_args(), $pluginInfo) : parent::getFacebookViewContentTrack($product, $category);
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookInitiateCheckoutTrack()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookInitiateCheckoutTrack');
        return $pluginInfo ? $this->___callPlugins('getFacebookInitiateCheckoutTrack', func_get_args(), $pluginInfo) : parent::getFacebookInitiateCheckoutTrack();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookAddToCartTrack()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookAddToCartTrack');
        return $pluginInfo ? $this->___callPlugins('getFacebookAddToCartTrack', func_get_args(), $pluginInfo) : parent::getFacebookAddToCartTrack();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookPurchaseTrack()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookPurchaseTrack');
        return $pluginInfo ? $this->___callPlugins('getFacebookPurchaseTrack', func_get_args(), $pluginInfo) : parent::getFacebookPurchaseTrack();
    }

    /**
     * {@inheritdoc}
     */
    public function facebook()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'facebook');
        return $pluginInfo ? $this->___callPlugins('facebook', func_get_args(), $pluginInfo) : parent::facebook();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookPixelCode() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookPixelCode');
        return $pluginInfo ? $this->___callPlugins('getFacebookPixelCode', func_get_args(), $pluginInfo) : parent::getFacebookPixelCode();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookCookieTriggerEvent() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookCookieTriggerEvent');
        return $pluginInfo ? $this->___callPlugins('getFacebookCookieTriggerEvent', func_get_args(), $pluginInfo) : parent::getFacebookCookieTriggerEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookPixelCodePlain() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookPixelCodePlain');
        return $pluginInfo ? $this->___callPlugins('getFacebookPixelCodePlain', func_get_args(), $pluginInfo) : parent::getFacebookPixelCodePlain();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookAdvancedMatchingParameters()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookAdvancedMatchingParameters');
        return $pluginInfo ? $this->___callPlugins('getFacebookAdvancedMatchingParameters', func_get_args(), $pluginInfo) : parent::getFacebookAdvancedMatchingParameters();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomer()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomer');
        return $pluginInfo ? $this->___callPlugins('getCustomer', func_get_args(), $pluginInfo) : parent::getCustomer();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerEmail(\Magento\Sales\Model\Order $order) : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerEmail');
        return $pluginInfo ? $this->___callPlugins('getCustomerEmail', func_get_args(), $pluginInfo) : parent::getCustomerEmail($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getVisitorId()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getVisitorId');
        return $pluginInfo ? $this->___callPlugins('getVisitorId', func_get_args(), $pluginInfo) : parent::getVisitorId();
    }

    /**
     * {@inheritdoc}
     */
    public function getSuper()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getSuper');
        return $pluginInfo ? $this->___callPlugins('getSuper', func_get_args(), $pluginInfo) : parent::getSuper();
    }

    /**
     * {@inheritdoc}
     */
    public function getConfigurableSimples()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getConfigurableSimples');
        return $pluginInfo ? $this->___callPlugins('getConfigurableSimples', func_get_args(), $pluginInfo) : parent::getConfigurableSimples();
    }

    /**
     * {@inheritdoc}
     */
    public function getBundle()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getBundle');
        return $pluginInfo ? $this->___callPlugins('getBundle', func_get_args(), $pluginInfo) : parent::getBundle();
    }

    /**
     * {@inheritdoc}
     */
    public function getAttributeLabel(\Magento\Catalog\Model\ResourceModel\Eav\Attribute $attribute)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAttributeLabel');
        return $pluginInfo ? $this->___callPlugins('getAttributeLabel', func_get_args(), $pluginInfo) : parent::getAttributeLabel($attribute);
    }

    /**
     * {@inheritdoc}
     */
    public function getPriceItem(\Magento\Quote\Model\Quote\Item $item) : float
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getPriceItem');
        return $pluginInfo ? $this->___callPlugins('getPriceItem', func_get_args(), $pluginInfo) : parent::getPriceItem($item);
    }

    /**
     * {@inheritdoc}
     */
    public function getPrice(\Magento\Catalog\Model\Product $product)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getPrice');
        return $pluginInfo ? $this->___callPlugins('getPrice', func_get_args(), $pluginInfo) : parent::getPrice($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getStock(\Magento\Catalog\Model\Product $product)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getStock');
        return $pluginInfo ? $this->___callPlugins('getStock', func_get_args(), $pluginInfo) : parent::getStock($product);
    }

    /**
     * {@inheritdoc}
     */
    public function assignCategory(\Magento\Catalog\Model\Category $category, array $item = []) : array
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'assignCategory');
        return $pluginInfo ? $this->___callPlugins('assignCategory', func_get_args(), $pluginInfo) : parent::assignCategory($category, $item);
    }

    /**
     * {@inheritdoc}
     */
    public function getCategory(\Magento\Catalog\Model\Category $category)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCategory');
        return $pluginInfo ? $this->___callPlugins('getCategory', func_get_args(), $pluginInfo) : parent::getCategory($category);
    }

    /**
     * {@inheritdoc}
     */
    public function getCategoryDetailList(\Magento\Catalog\Model\Product $product, \Magento\Catalog\Model\Category $category)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCategoryDetailList');
        return $pluginInfo ? $this->___callPlugins('getCategoryDetailList', func_get_args(), $pluginInfo) : parent::getCategoryDetailList($product, $category);
    }

    /**
     * {@inheritdoc}
     */
    public function getCategoryList(\Magento\Catalog\Model\Category $category)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCategoryList');
        return $pluginInfo ? $this->___callPlugins('getCategoryList', func_get_args(), $pluginInfo) : parent::getCategoryList($category);
    }

    /**
     * {@inheritdoc}
     */
    public function getCategorySegments(\Magento\Catalog\Model\Category $category)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCategorySegments');
        return $pluginInfo ? $this->___callPlugins('getCategorySegments', func_get_args(), $pluginInfo) : parent::getCategorySegments($category);
    }

    /**
     * {@inheritdoc}
     */
    public function getReviewsCount(\Magento\Catalog\Model\Product $product) : int
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getReviewsCount');
        return $pluginInfo ? $this->___callPlugins('getReviewsCount', func_get_args(), $pluginInfo) : parent::getReviewsCount($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getRatingSummary(\Magento\Catalog\Model\Product $product) : float
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getRatingSummary');
        return $pluginInfo ? $this->___callPlugins('getRatingSummary', func_get_args(), $pluginInfo) : parent::getRatingSummary($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getBrand(\Magento\Catalog\Model\Product $product)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getBrand');
        return $pluginInfo ? $this->___callPlugins('getBrand', func_get_args(), $pluginInfo) : parent::getBrand($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookValueKey()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookValueKey');
        return $pluginInfo ? $this->___callPlugins('getFacebookValueKey', func_get_args(), $pluginInfo) : parent::getFacebookValueKey();
    }

    /**
     * {@inheritdoc}
     */
    public function getStore()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getStore');
        return $pluginInfo ? $this->___callPlugins('getStore', func_get_args(), $pluginInfo) : parent::getStore();
    }

    /**
     * {@inheritdoc}
     */
    public function getStoreName()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getStoreName');
        return $pluginInfo ? $this->___callPlugins('getStoreName', func_get_args(), $pluginInfo) : parent::getStoreName();
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrency()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCurrency');
        return $pluginInfo ? $this->___callPlugins('getCurrency', func_get_args(), $pluginInfo) : parent::getCurrency();
    }

    /**
     * {@inheritdoc}
     */
    public function getBodySnippet()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getBodySnippet');
        return $pluginInfo ? $this->___callPlugins('getBodySnippet', func_get_args(), $pluginInfo) : parent::getBodySnippet();
    }

    /**
     * {@inheritdoc}
     */
    public function getHeadSnippet()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getHeadSnippet');
        return $pluginInfo ? $this->___callPlugins('getHeadSnippet', func_get_args(), $pluginInfo) : parent::getHeadSnippet();
    }

    /**
     * {@inheritdoc}
     */
    public function generateNonce() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'generateNonce');
        return $pluginInfo ? $this->___callPlugins('generateNonce', func_get_args(), $pluginInfo) : parent::generateNonce();
    }

    /**
     * {@inheritdoc}
     */
    public function getGoogleOptimizePageHidingSnippet()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getGoogleOptimizePageHidingSnippet');
        return $pluginInfo ? $this->___callPlugins('getGoogleOptimizePageHidingSnippet', func_get_args(), $pluginInfo) : parent::getGoogleOptimizePageHidingSnippet();
    }

    /**
     * {@inheritdoc}
     */
    public function getGoogleAdsRemarketingTriggerEvent() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getGoogleAdsRemarketingTriggerEvent');
        return $pluginInfo ? $this->___callPlugins('getGoogleAdsRemarketingTriggerEvent', func_get_args(), $pluginInfo) : parent::getGoogleAdsRemarketingTriggerEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function getGoogleOptimizeIsStandalone()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getGoogleOptimizeIsStandalone');
        return $pluginInfo ? $this->___callPlugins('getGoogleOptimizeIsStandalone', func_get_args(), $pluginInfo) : parent::getGoogleOptimizeIsStandalone();
    }

    /**
     * {@inheritdoc}
     */
    public function getGoogleOptimizeIsAssisted()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getGoogleOptimizeIsAssisted');
        return $pluginInfo ? $this->___callPlugins('getGoogleOptimizeIsAssisted', func_get_args(), $pluginInfo) : parent::getGoogleOptimizeIsAssisted();
    }

    /**
     * {@inheritdoc}
     */
    public function getGoogleOptimizeContainerId()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getGoogleOptimizeContainerId');
        return $pluginInfo ? $this->___callPlugins('getGoogleOptimizeContainerId', func_get_args(), $pluginInfo) : parent::getGoogleOptimizeContainerId();
    }

    /**
     * {@inheritdoc}
     */
    public function getGoogleOptimizeAnalyticsId()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getGoogleOptimizeAnalyticsId');
        return $pluginInfo ? $this->___callPlugins('getGoogleOptimizeAnalyticsId', func_get_args(), $pluginInfo) : parent::getGoogleOptimizeAnalyticsId();
    }

    /**
     * {@inheritdoc}
     */
    public function getContactEvent()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getContactEvent');
        return $pluginInfo ? $this->___callPlugins('getContactEvent', func_get_args(), $pluginInfo) : parent::getContactEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function getCartUpdateEvent()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCartUpdateEvent');
        return $pluginInfo ? $this->___callPlugins('getCartUpdateEvent', func_get_args(), $pluginInfo) : parent::getCartUpdateEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function getNewsletterEvent()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getNewsletterEvent');
        return $pluginInfo ? $this->___callPlugins('getNewsletterEvent', func_get_args(), $pluginInfo) : parent::getNewsletterEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerRegisterEvent()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerRegisterEvent');
        return $pluginInfo ? $this->___callPlugins('getCustomerRegisterEvent', func_get_args(), $pluginInfo) : parent::getCustomerRegisterEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerLoginEvent()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerLoginEvent');
        return $pluginInfo ? $this->___callPlugins('getCustomerLoginEvent', func_get_args(), $pluginInfo) : parent::getCustomerLoginEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookEvents()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookEvents');
        return $pluginInfo ? $this->___callPlugins('getFacebookEvents', func_get_args(), $pluginInfo) : parent::getFacebookEvents();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookCompleteRegistrationEvent()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookCompleteRegistrationEvent');
        return $pluginInfo ? $this->___callPlugins('getFacebookCompleteRegistrationEvent', func_get_args(), $pluginInfo) : parent::getFacebookCompleteRegistrationEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function getStoreRootDefaultCategoryId()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getStoreRootDefaultCategoryId');
        return $pluginInfo ? $this->___callPlugins('getStoreRootDefaultCategoryId', func_get_args(), $pluginInfo) : parent::getStoreRootDefaultCategoryId();
    }

    /**
     * {@inheritdoc}
     */
    public function getStoreRootCategoryId($store)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getStoreRootCategoryId');
        return $pluginInfo ? $this->___callPlugins('getStoreRootCategoryId', func_get_args(), $pluginInfo) : parent::getStoreRootCategoryId($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getPageType() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getPageType');
        return $pluginInfo ? $this->___callPlugins('getPageType', func_get_args(), $pluginInfo) : parent::getPageType();
    }

    /**
     * {@inheritdoc}
     */
    public function getIsHomePage() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getIsHomePage');
        return $pluginInfo ? $this->___callPlugins('getIsHomePage', func_get_args(), $pluginInfo) : parent::getIsHomePage();
    }

    /**
     * {@inheritdoc}
     */
    public function getAllStoreRootCategories()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAllStoreRootCategories');
        return $pluginInfo ? $this->___callPlugins('getAllStoreRootCategories', func_get_args(), $pluginInfo) : parent::getAllStoreRootCategories();
    }

    /**
     * {@inheritdoc}
     */
    public function isActive() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isActive');
        return $pluginInfo ? $this->___callPlugins('isActive', func_get_args(), $pluginInfo) : parent::isActive();
    }

    /**
     * {@inheritdoc}
     */
    public function isLogged()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isLogged');
        return $pluginInfo ? $this->___callPlugins('isLogged', func_get_args(), $pluginInfo) : parent::isLogged();
    }

    /**
     * {@inheritdoc}
     */
    public function isDisabledByIp() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isDisabledByIp');
        return $pluginInfo ? $this->___callPlugins('isDisabledByIp', func_get_args(), $pluginInfo) : parent::isDisabledByIp();
    }

    /**
     * {@inheritdoc}
     */
    public function isAuthDisabledByIp() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isAuthDisabledByIp');
        return $pluginInfo ? $this->___callPlugins('isAuthDisabledByIp', func_get_args(), $pluginInfo) : parent::isAuthDisabledByIp();
    }

    /**
     * {@inheritdoc}
     */
    public function isIpMatch($config) : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isIpMatch');
        return $pluginInfo ? $this->___callPlugins('isIpMatch', func_get_args(), $pluginInfo) : parent::isIpMatch($config);
    }

    /**
     * {@inheritdoc}
     */
    public function isAdwordsConversionTrackingActive($consent = false)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isAdwordsConversionTrackingActive');
        return $pluginInfo ? $this->___callPlugins('isAdwordsConversionTrackingActive', func_get_args(), $pluginInfo) : parent::isAdwordsConversionTrackingActive($consent);
    }

    /**
     * {@inheritdoc}
     */
    public function isCustomerReviewsActive() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isCustomerReviewsActive');
        return $pluginInfo ? $this->___callPlugins('isCustomerReviewsActive', func_get_args(), $pluginInfo) : parent::isCustomerReviewsActive();
    }

    /**
     * {@inheritdoc}
     */
    public function isCustomerReviewsGTIN() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isCustomerReviewsGTIN');
        return $pluginInfo ? $this->___callPlugins('isCustomerReviewsGTIN', func_get_args(), $pluginInfo) : parent::isCustomerReviewsGTIN();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerReviewsGTINAttribute()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerReviewsGTINAttribute');
        return $pluginInfo ? $this->___callPlugins('getCustomerReviewsGTINAttribute', func_get_args(), $pluginInfo) : parent::getCustomerReviewsGTINAttribute();
    }

    /**
     * {@inheritdoc}
     */
    public function useAdwordsConversionTrackingGtag()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useAdwordsConversionTrackingGtag');
        return $pluginInfo ? $this->___callPlugins('useAdwordsConversionTrackingGtag', func_get_args(), $pluginInfo) : parent::useAdwordsConversionTrackingGtag();
    }

    /**
     * {@inheritdoc}
     */
    public function usePrivateFallback()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'usePrivateFallback');
        return $pluginInfo ? $this->___callPlugins('usePrivateFallback', func_get_args(), $pluginInfo) : parent::usePrivateFallback();
    }

    /**
     * {@inheritdoc}
     */
    public function useRemoveConfirm()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useRemoveConfirm');
        return $pluginInfo ? $this->___callPlugins('useRemoveConfirm', func_get_args(), $pluginInfo) : parent::useRemoveConfirm();
    }

    /**
     * {@inheritdoc}
     */
    public function useLocalStorage()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useLocalStorage');
        return $pluginInfo ? $this->___callPlugins('useLocalStorage', func_get_args(), $pluginInfo) : parent::useLocalStorage();
    }

    /**
     * {@inheritdoc}
     */
    public function useMeasurementProtocol() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useMeasurementProtocol');
        return $pluginInfo ? $this->___callPlugins('useMeasurementProtocol', func_get_args(), $pluginInfo) : parent::useMeasurementProtocol();
    }

    /**
     * {@inheritdoc}
     */
    public function useMeasurementProtocolOnly() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useMeasurementProtocolOnly');
        return $pluginInfo ? $this->___callPlugins('useMeasurementProtocolOnly', func_get_args(), $pluginInfo) : parent::useMeasurementProtocolOnly();
    }

    /**
     * {@inheritdoc}
     */
    public function useMeasurementProtocolOnlyPlaced() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useMeasurementProtocolOnlyPlaced');
        return $pluginInfo ? $this->___callPlugins('useMeasurementProtocolOnlyPlaced', func_get_args(), $pluginInfo) : parent::useMeasurementProtocolOnlyPlaced();
    }

    /**
     * {@inheritdoc}
     */
    public function useMeasurementProtocolOnlyKeepEvent() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useMeasurementProtocolOnlyKeepEvent');
        return $pluginInfo ? $this->___callPlugins('useMeasurementProtocolOnlyKeepEvent', func_get_args(), $pluginInfo) : parent::useMeasurementProtocolOnlyKeepEvent();
    }

    /**
     * {@inheritdoc}
     */
    public function useMeasurementProtocolOnlyKeepEnhancedConversionData() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useMeasurementProtocolOnlyKeepEnhancedConversionData');
        return $pluginInfo ? $this->___callPlugins('useMeasurementProtocolOnlyKeepEnhancedConversionData', func_get_args(), $pluginInfo) : parent::useMeasurementProtocolOnlyKeepEnhancedConversionData();
    }

    /**
     * {@inheritdoc}
     */
    public function useMeasurementProtocolCancel() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useMeasurementProtocolCancel');
        return $pluginInfo ? $this->___callPlugins('useMeasurementProtocolCancel', func_get_args(), $pluginInfo) : parent::useMeasurementProtocolCancel();
    }

    /**
     * {@inheritdoc}
     */
    public function useMeasurementProtocolRefund() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useMeasurementProtocolRefund');
        return $pluginInfo ? $this->___callPlugins('useMeasurementProtocolRefund', func_get_args(), $pluginInfo) : parent::useMeasurementProtocolRefund();
    }

    /**
     * {@inheritdoc}
     */
    public function getUseLocalStorage()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getUseLocalStorage');
        return $pluginInfo ? $this->___callPlugins('getUseLocalStorage', func_get_args(), $pluginInfo) : parent::getUseLocalStorage();
    }

    /**
     * {@inheritdoc}
     */
    public function getUseRemoveConfirm()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getUseRemoveConfirm');
        return $pluginInfo ? $this->___callPlugins('getUseRemoveConfirm', func_get_args(), $pluginInfo) : parent::getUseRemoveConfirm();
    }

    /**
     * {@inheritdoc}
     */
    public function getBrandDelimueter() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getBrandDelimueter');
        return $pluginInfo ? $this->___callPlugins('getBrandDelimueter', func_get_args(), $pluginInfo) : parent::getBrandDelimueter();
    }

    /**
     * {@inheritdoc}
     */
    public function getAdwordsConversionTrackingGtagSiteTag()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAdwordsConversionTrackingGtagSiteTag');
        return $pluginInfo ? $this->___callPlugins('getAdwordsConversionTrackingGtagSiteTag', func_get_args(), $pluginInfo) : parent::getAdwordsConversionTrackingGtagSiteTag();
    }

    /**
     * {@inheritdoc}
     */
    public function getAdwordsConversionTrackingGtagSendToParameter()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAdwordsConversionTrackingGtagSendToParameter');
        return $pluginInfo ? $this->___callPlugins('getAdwordsConversionTrackingGtagSendToParameter', func_get_args(), $pluginInfo) : parent::getAdwordsConversionTrackingGtagSendToParameter();
    }

    /**
     * {@inheritdoc}
     */
    public function getAdwordsConversionTrackingGtagConvesionEvent(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAdwordsConversionTrackingGtagConvesionEvent');
        return $pluginInfo ? $this->___callPlugins('getAdwordsConversionTrackingGtagConvesionEvent', func_get_args(), $pluginInfo) : parent::getAdwordsConversionTrackingGtagConvesionEvent($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getEnhancedConversionVariable(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getEnhancedConversionVariable');
        return $pluginInfo ? $this->___callPlugins('getEnhancedConversionVariable', func_get_args(), $pluginInfo) : parent::getEnhancedConversionVariable($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getInitialBinding()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getInitialBinding');
        return $pluginInfo ? $this->___callPlugins('getInitialBinding', func_get_args(), $pluginInfo) : parent::getInitialBinding();
    }

    /**
     * {@inheritdoc}
     */
    public function useDefaultValues()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useDefaultValues');
        return $pluginInfo ? $this->___callPlugins('useDefaultValues', func_get_args(), $pluginInfo) : parent::useDefaultValues();
    }

    /**
     * {@inheritdoc}
     */
    public function useSimples() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useSimples');
        return $pluginInfo ? $this->___callPlugins('useSimples', func_get_args(), $pluginInfo) : parent::useSimples();
    }

    /**
     * {@inheritdoc}
     */
    public function useVariantSku() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useVariantSku');
        return $pluginInfo ? $this->___callPlugins('useVariantSku', func_get_args(), $pluginInfo) : parent::useVariantSku();
    }

    /**
     * {@inheritdoc}
     */
    public function usePlaceholders()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'usePlaceholders');
        return $pluginInfo ? $this->___callPlugins('usePlaceholders', func_get_args(), $pluginInfo) : parent::usePlaceholders();
    }

    /**
     * {@inheritdoc}
     */
    public function useDebugMode() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useDebugMode');
        return $pluginInfo ? $this->___callPlugins('useDebugMode', func_get_args(), $pluginInfo) : parent::useDebugMode();
    }

    /**
     * {@inheritdoc}
     */
    public function useOptimize() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useOptimize');
        return $pluginInfo ? $this->___callPlugins('useOptimize', func_get_args(), $pluginInfo) : parent::useOptimize();
    }

    /**
     * {@inheritdoc}
     */
    public function useOptimizeCompress() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useOptimizeCompress');
        return $pluginInfo ? $this->___callPlugins('useOptimizeCompress', func_get_args(), $pluginInfo) : parent::useOptimizeCompress();
    }

    /**
     * {@inheritdoc}
     */
    public function usePreRenderImpressionPayloadModel()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'usePreRenderImpressionPayloadModel');
        return $pluginInfo ? $this->___callPlugins('usePreRenderImpressionPayloadModel', func_get_args(), $pluginInfo) : parent::usePreRenderImpressionPayloadModel();
    }

    /**
     * {@inheritdoc}
     */
    public function usePostRenderImpressionPayloadModel()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'usePostRenderImpressionPayloadModel');
        return $pluginInfo ? $this->___callPlugins('usePostRenderImpressionPayloadModel', func_get_args(), $pluginInfo) : parent::usePostRenderImpressionPayloadModel();
    }

    /**
     * {@inheritdoc}
     */
    public function useSummary() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useSummary');
        return $pluginInfo ? $this->___callPlugins('useSummary', func_get_args(), $pluginInfo) : parent::useSummary();
    }

    /**
     * {@inheritdoc}
     */
    public function useReset() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'useReset');
        return $pluginInfo ? $this->___callPlugins('useReset', func_get_args(), $pluginInfo) : parent::useReset();
    }

    /**
     * {@inheritdoc}
     */
    public function supportPerformance()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'supportPerformance');
        return $pluginInfo ? $this->___callPlugins('supportPerformance', func_get_args(), $pluginInfo) : parent::supportPerformance();
    }

    /**
     * {@inheritdoc}
     */
    public function supportAmp()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'supportAmp');
        return $pluginInfo ? $this->___callPlugins('supportAmp', func_get_args(), $pluginInfo) : parent::supportAmp();
    }

    /**
     * {@inheritdoc}
     */
    public function supportDynx()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'supportDynx');
        return $pluginInfo ? $this->___callPlugins('supportDynx', func_get_args(), $pluginInfo) : parent::supportDynx();
    }

    /**
     * {@inheritdoc}
     */
    public function supportEnhancedConversions() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'supportEnhancedConversions');
        return $pluginInfo ? $this->___callPlugins('supportEnhancedConversions', func_get_args(), $pluginInfo) : parent::supportEnhancedConversions();
    }

    /**
     * {@inheritdoc}
     */
    public function supportFacebookConversionsApi() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'supportFacebookConversionsApi');
        return $pluginInfo ? $this->___callPlugins('supportFacebookConversionsApi', func_get_args(), $pluginInfo) : parent::supportFacebookConversionsApi();
    }

    /**
     * {@inheritdoc}
     */
    public function supportInternalSearch()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'supportInternalSearch');
        return $pluginInfo ? $this->___callPlugins('supportInternalSearch', func_get_args(), $pluginInfo) : parent::supportInternalSearch();
    }

    /**
     * {@inheritdoc}
     */
    public function supportCookieDirective()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'supportCookieDirective');
        return $pluginInfo ? $this->___callPlugins('supportCookieDirective', func_get_args(), $pluginInfo) : parent::supportCookieDirective();
    }

    /**
     * {@inheritdoc}
     */
    public function getSegmentCheckall() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getSegmentCheckall');
        return $pluginInfo ? $this->___callPlugins('getSegmentCheckall', func_get_args(), $pluginInfo) : parent::getSegmentCheckall();
    }

    /**
     * {@inheritdoc}
     */
    public function getKeepCookieWidget() : int
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getKeepCookieWidget');
        return $pluginInfo ? $this->___callPlugins('getKeepCookieWidget', func_get_args(), $pluginInfo) : parent::getKeepCookieWidget();
    }

    /**
     * {@inheritdoc}
     */
    public function getKeepCookieWidgetColor() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getKeepCookieWidgetColor');
        return $pluginInfo ? $this->___callPlugins('getKeepCookieWidgetColor', func_get_args(), $pluginInfo) : parent::getKeepCookieWidgetColor();
    }

    /**
     * {@inheritdoc}
     */
    public function getKeepCookieWidgetColorEnd() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getKeepCookieWidgetColorEnd');
        return $pluginInfo ? $this->___callPlugins('getKeepCookieWidgetColorEnd', func_get_args(), $pluginInfo) : parent::getKeepCookieWidgetColorEnd();
    }

    /**
     * {@inheritdoc}
     */
    public function hideCookieWidget() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'hideCookieWidget');
        return $pluginInfo ? $this->___callPlugins('hideCookieWidget', func_get_args(), $pluginInfo) : parent::hideCookieWidget();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieWidgetOptions() : array
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieWidgetOptions');
        return $pluginInfo ? $this->___callPlugins('getCookieWidgetOptions', func_get_args(), $pluginInfo) : parent::getCookieWidgetOptions();
    }

    /**
     * {@inheritdoc}
     */
    public function getGoogleBuiltinConsent() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getGoogleBuiltinConsent');
        return $pluginInfo ? $this->___callPlugins('getGoogleBuiltinConsent', func_get_args(), $pluginInfo) : parent::getGoogleBuiltinConsent();
    }

    /**
     * {@inheritdoc}
     */
    public function isCookieConsentAccepted()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isCookieConsentAccepted');
        return $pluginInfo ? $this->___callPlugins('isCookieConsentAccepted', func_get_args(), $pluginInfo) : parent::isCookieConsentAccepted();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookConversionsApiPixelId() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookConversionsApiPixelId');
        return $pluginInfo ? $this->___callPlugins('getFacebookConversionsApiPixelId', func_get_args(), $pluginInfo) : parent::getFacebookConversionsApiPixelId();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookConversionsApiAccessToken() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookConversionsApiAccessToken');
        return $pluginInfo ? $this->___callPlugins('getFacebookConversionsApiAccessToken', func_get_args(), $pluginInfo) : parent::getFacebookConversionsApiAccessToken();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookConversionsApiTestEventCode() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookConversionsApiTestEventCode');
        return $pluginInfo ? $this->___callPlugins('getFacebookConversionsApiTestEventCode', func_get_args(), $pluginInfo) : parent::getFacebookConversionsApiTestEventCode();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveContent()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveContent');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveContent', func_get_args(), $pluginInfo) : parent::getCookieDirectiveContent();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveOverrideDecline() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveOverrideDecline');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveOverrideDecline', func_get_args(), $pluginInfo) : parent::getCookieDirectiveOverrideDecline();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveConsentMode()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveConsentMode');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveConsentMode', func_get_args(), $pluginInfo) : parent::getCookieDirectiveConsentMode();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveIsSegmentMode() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveIsSegmentMode');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveIsSegmentMode', func_get_args(), $pluginInfo) : parent::getCookieDirectiveIsSegmentMode();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveConsentSegments()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveConsentSegments');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveConsentSegments', func_get_args(), $pluginInfo) : parent::getCookieDirectiveConsentSegments();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveBackgroundColor()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveBackgroundColor');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveBackgroundColor', func_get_args(), $pluginInfo) : parent::getCookieDirectiveBackgroundColor();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveCloseIconBackgroundColor()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveCloseIconBackgroundColor');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveCloseIconBackgroundColor', func_get_args(), $pluginInfo) : parent::getCookieDirectiveCloseIconBackgroundColor();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveCustomizeLinkColor()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveCustomizeLinkColor');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveCustomizeLinkColor', func_get_args(), $pluginInfo) : parent::getCookieDirectiveCustomizeLinkColor();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveRadius() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveRadius');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveRadius', func_get_args(), $pluginInfo) : parent::getCookieDirectiveRadius();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrderFilterOutMethods()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getOrderFilterOutMethods');
        return $pluginInfo ? $this->___callPlugins('getOrderFilterOutMethods', func_get_args(), $pluginInfo) : parent::getOrderFilterOutMethods();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveTextColor()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveTextColor');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveTextColor', func_get_args(), $pluginInfo) : parent::getCookieDirectiveTextColor();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveTextAcceptColor()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveTextAcceptColor');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveTextAcceptColor', func_get_args(), $pluginInfo) : parent::getCookieDirectiveTextAcceptColor();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveCheckboxColor()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveCheckboxColor');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveCheckboxColor', func_get_args(), $pluginInfo) : parent::getCookieDirectiveCheckboxColor();
    }

    /**
     * {@inheritdoc}
     */
    public function getCookieDirectiveShowDeclineButton() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCookieDirectiveShowDeclineButton');
        return $pluginInfo ? $this->___callPlugins('getCookieDirectiveShowDeclineButton', func_get_args(), $pluginInfo) : parent::getCookieDirectiveShowDeclineButton();
    }

    /**
     * {@inheritdoc}
     */
    public function getImpressionPayloadModel()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getImpressionPayloadModel');
        return $pluginInfo ? $this->___callPlugins('getImpressionPayloadModel', func_get_args(), $pluginInfo) : parent::getImpressionPayloadModel();
    }

    /**
     * {@inheritdoc}
     */
    public function getPriceRenderTaxType() : int
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getPriceRenderTaxType');
        return $pluginInfo ? $this->___callPlugins('getPriceRenderTaxType', func_get_args(), $pluginInfo) : parent::getPriceRenderTaxType();
    }

    /**
     * {@inheritdoc}
     */
    public function getInternalSearchDimension()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getInternalSearchDimension');
        return $pluginInfo ? $this->___callPlugins('getInternalSearchDimension', func_get_args(), $pluginInfo) : parent::getInternalSearchDimension();
    }

    /**
     * {@inheritdoc}
     */
    public function getStockDimensionIndex($key = false)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getStockDimensionIndex');
        return $pluginInfo ? $this->___callPlugins('getStockDimensionIndex', func_get_args(), $pluginInfo) : parent::getStockDimensionIndex($key);
    }

    /**
     * {@inheritdoc}
     */
    public function addInternalSearchDimension(array &$attributes = [])
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'addInternalSearchDimension');
        return $pluginInfo ? $this->___callPlugins('addInternalSearchDimension', func_get_args(), $pluginInfo) : parent::addInternalSearchDimension($attributes);
    }

    /**
     * {@inheritdoc}
     */
    public function isEnterprise()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isEnterprise');
        return $pluginInfo ? $this->___callPlugins('isEnterprise', func_get_args(), $pluginInfo) : parent::isEnterprise();
    }

    /**
     * {@inheritdoc}
     */
    public function isCommunity()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isCommunity');
        return $pluginInfo ? $this->___callPlugins('isCommunity', func_get_args(), $pluginInfo) : parent::isCommunity();
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrentStoreProductCategories(\Magento\Catalog\Model\Product $product)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCurrentStoreProductCategories');
        return $pluginInfo ? $this->___callPlugins('getCurrentStoreProductCategories', func_get_args(), $pluginInfo) : parent::getCurrentStoreProductCategories($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrentStoreCategories(array $intersect = [])
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCurrentStoreCategories');
        return $pluginInfo ? $this->___callPlugins('getCurrentStoreCategories', func_get_args(), $pluginInfo) : parent::getCurrentStoreCategories($intersect);
    }

    /**
     * {@inheritdoc}
     */
    public function getIsReturnCustomer()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getIsReturnCustomer');
        return $pluginInfo ? $this->___callPlugins('getIsReturnCustomer', func_get_args(), $pluginInfo) : parent::getIsReturnCustomer();
    }

    /**
     * {@inheritdoc}
     */
    public function getIsNewCustomer(\Magento\Sales\Api\Data\OrderInterface $order) : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getIsNewCustomer');
        return $pluginInfo ? $this->___callPlugins('getIsNewCustomer', func_get_args(), $pluginInfo) : parent::getIsNewCustomer($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookRemarketingId(\Magento\Catalog\Model\Product $product)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookRemarketingId');
        return $pluginInfo ? $this->___callPlugins('getFacebookRemarketingId', func_get_args(), $pluginInfo) : parent::getFacebookRemarketingId($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getAdwordsRemarketingId(\Magento\Catalog\Model\Product $product)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAdwordsRemarketingId');
        return $pluginInfo ? $this->___callPlugins('getAdwordsRemarketingId', func_get_args(), $pluginInfo) : parent::getAdwordsRemarketingId($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getAttribute(\Magento\Catalog\Model\Product $product, $config)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAttribute');
        return $pluginInfo ? $this->___callPlugins('getAttribute', func_get_args(), $pluginInfo) : parent::getAttribute($product, $config);
    }

    /**
     * {@inheritdoc}
     */
    public function getAdwordsEcommProdId(\Magento\Framework\Api\ExtensibleDataInterface $item)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAdwordsEcommProdId');
        return $pluginInfo ? $this->___callPlugins('getAdwordsEcommProdId', func_get_args(), $pluginInfo) : parent::getAdwordsEcommProdId($item);
    }

    /**
     * {@inheritdoc}
     */
    public function getFirstChild($product)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFirstChild');
        return $pluginInfo ? $this->___callPlugins('getFirstChild', func_get_args(), $pluginInfo) : parent::getFirstChild($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getVersion()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getVersion');
        return $pluginInfo ? $this->___callPlugins('getVersion', func_get_args(), $pluginInfo) : parent::getVersion();
    }

    /**
     * {@inheritdoc}
     */
    public function getIdentifier(\Magento\Framework\Model\AbstractExtensibleModel $product)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getIdentifier');
        return $pluginInfo ? $this->___callPlugins('getIdentifier', func_get_args(), $pluginInfo) : parent::getIdentifier($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getIdentifierItem(\Magento\Framework\Api\ExtensibleDataInterface $item)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getIdentifierItem');
        return $pluginInfo ? $this->___callPlugins('getIdentifierItem', func_get_args(), $pluginInfo) : parent::getIdentifierItem($item);
    }

    /**
     * {@inheritdoc}
     */
    public function getDatalayerAttributes() : array
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getDatalayerAttributes');
        return $pluginInfo ? $this->___callPlugins('getDatalayerAttributes', func_get_args(), $pluginInfo) : parent::getDatalayerAttributes();
    }

    /**
     * {@inheritdoc}
     */
    public function getDataLayerAttributesArray(string $sku = '') : array
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getDataLayerAttributesArray');
        return $pluginInfo ? $this->___callPlugins('getDataLayerAttributesArray', func_get_args(), $pluginInfo) : parent::getDataLayerAttributesArray($sku);
    }

    /**
     * {@inheritdoc}
     */
    public function getListSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getListSelector');
        return $pluginInfo ? $this->___callPlugins('getListSelector', func_get_args(), $pluginInfo) : parent::getListSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getListCrossSellSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getListCrossSellSelector');
        return $pluginInfo ? $this->___callPlugins('getListCrossSellSelector', func_get_args(), $pluginInfo) : parent::getListCrossSellSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getWishlistSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getWishlistSelector');
        return $pluginInfo ? $this->___callPlugins('getWishlistSelector', func_get_args(), $pluginInfo) : parent::getWishlistSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getCompareSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCompareSelector');
        return $pluginInfo ? $this->___callPlugins('getCompareSelector', func_get_args(), $pluginInfo) : parent::getCompareSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getListWidgetSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getListWidgetSelector');
        return $pluginInfo ? $this->___callPlugins('getListWidgetSelector', func_get_args(), $pluginInfo) : parent::getListWidgetSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getListWidgetClickSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getListWidgetClickSelector');
        return $pluginInfo ? $this->___callPlugins('getListWidgetClickSelector', func_get_args(), $pluginInfo) : parent::getListWidgetClickSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getListWidgetCartCategorySelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getListWidgetCartCategorySelector');
        return $pluginInfo ? $this->___callPlugins('getListWidgetCartCategorySelector', func_get_args(), $pluginInfo) : parent::getListWidgetCartCategorySelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getListClickSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getListClickSelector');
        return $pluginInfo ? $this->___callPlugins('getListClickSelector', func_get_args(), $pluginInfo) : parent::getListClickSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getListWishlistSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getListWishlistSelector');
        return $pluginInfo ? $this->___callPlugins('getListWishlistSelector', func_get_args(), $pluginInfo) : parent::getListWishlistSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getListCompareSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getListCompareSelector');
        return $pluginInfo ? $this->___callPlugins('getListCompareSelector', func_get_args(), $pluginInfo) : parent::getListCompareSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getCartSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCartSelector');
        return $pluginInfo ? $this->___callPlugins('getCartSelector', func_get_args(), $pluginInfo) : parent::getCartSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getCartCategorySelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCartCategorySelector');
        return $pluginInfo ? $this->___callPlugins('getCartCategorySelector', func_get_args(), $pluginInfo) : parent::getCartCategorySelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getDeleteSelector()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getDeleteSelector');
        return $pluginInfo ? $this->___callPlugins('getDeleteSelector', func_get_args(), $pluginInfo) : parent::getDeleteSelector();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerReviewsPosition()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerReviewsPosition');
        return $pluginInfo ? $this->___callPlugins('getCustomerReviewsPosition', func_get_args(), $pluginInfo) : parent::getCustomerReviewsPosition();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerReviewsMerchantId()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerReviewsMerchantId');
        return $pluginInfo ? $this->___callPlugins('getCustomerReviewsMerchantId', func_get_args(), $pluginInfo) : parent::getCustomerReviewsMerchantId();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerReviewsDeliveryOffset()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerReviewsDeliveryOffset');
        return $pluginInfo ? $this->___callPlugins('getCustomerReviewsDeliveryOffset', func_get_args(), $pluginInfo) : parent::getCustomerReviewsDeliveryOffset();
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerReviewsDeliveryDate($offset)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerReviewsDeliveryDate');
        return $pluginInfo ? $this->___callPlugins('getCustomerReviewsDeliveryDate', func_get_args(), $pluginInfo) : parent::getCustomerReviewsDeliveryDate($offset);
    }

    /**
     * {@inheritdoc}
     */
    public function getCustomerReviewsPayload($block)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCustomerReviewsPayload');
        return $pluginInfo ? $this->___callPlugins('getCustomerReviewsPayload', func_get_args(), $pluginInfo) : parent::getCustomerReviewsPayload($block);
    }

    /**
     * {@inheritdoc}
     */
    public function getSearchAttributes()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getSearchAttributes');
        return $pluginInfo ? $this->___callPlugins('getSearchAttributes', func_get_args(), $pluginInfo) : parent::getSearchAttributes();
    }

    /**
     * {@inheritdoc}
     */
    public function getEventManager()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getEventManager');
        return $pluginInfo ? $this->___callPlugins('getEventManager', func_get_args(), $pluginInfo) : parent::getEventManager();
    }

    /**
     * {@inheritdoc}
     */
    public function getModuleManager()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getModuleManager');
        return $pluginInfo ? $this->___callPlugins('getModuleManager', func_get_args(), $pluginInfo) : parent::getModuleManager();
    }

    /**
     * {@inheritdoc}
     */
    public function getCategoryRepository()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getCategoryRepository');
        return $pluginInfo ? $this->___callPlugins('getCategoryRepository', func_get_args(), $pluginInfo) : parent::getCategoryRepository();
    }

    /**
     * {@inheritdoc}
     */
    public function getSalesOrderCollection()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getSalesOrderCollection');
        return $pluginInfo ? $this->___callPlugins('getSalesOrderCollection', func_get_args(), $pluginInfo) : parent::getSalesOrderCollection();
    }

    /**
     * {@inheritdoc}
     */
    public function getJsonHelper()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getJsonHelper');
        return $pluginInfo ? $this->___callPlugins('getJsonHelper', func_get_args(), $pluginInfo) : parent::getJsonHelper();
    }

    /**
     * {@inheritdoc}
     */
    public function getLayerResolver()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getLayerResolver');
        return $pluginInfo ? $this->___callPlugins('getLayerResolver', func_get_args(), $pluginInfo) : parent::getLayerResolver();
    }

    /**
     * {@inheritdoc}
     */
    public function getAttributes()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getAttributes');
        return $pluginInfo ? $this->___callPlugins('getAttributes', func_get_args(), $pluginInfo) : parent::getAttributes();
    }

    /**
     * {@inheritdoc}
     */
    public function getStoreManager()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getStoreManager');
        return $pluginInfo ? $this->___callPlugins('getStoreManager', func_get_args(), $pluginInfo) : parent::getStoreManager();
    }

    /**
     * {@inheritdoc}
     */
    public function getRequest()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getRequest');
        return $pluginInfo ? $this->___callPlugins('getRequest', func_get_args(), $pluginInfo) : parent::getRequest();
    }

    /**
     * {@inheritdoc}
     */
    public function getProductRepository()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getProductRepository');
        return $pluginInfo ? $this->___callPlugins('getProductRepository', func_get_args(), $pluginInfo) : parent::getProductRepository();
    }

    /**
     * {@inheritdoc}
     */
    public function getFormKey() : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFormKey');
        return $pluginInfo ? $this->___callPlugins('getFormKey', func_get_args(), $pluginInfo) : parent::getFormKey();
    }

    /**
     * {@inheritdoc}
     */
    public function getFacebookConversionsApi()
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getFacebookConversionsApi');
        return $pluginInfo ? $this->___callPlugins('getFacebookConversionsApi', func_get_args(), $pluginInfo) : parent::getFacebookConversionsApi();
    }

    /**
     * {@inheritdoc}
     */
    public function isDeferEnabled() : bool
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isDeferEnabled');
        return $pluginInfo ? $this->___callPlugins('isDeferEnabled', func_get_args(), $pluginInfo) : parent::isDeferEnabled();
    }

    /**
     * {@inheritdoc}
     */
    public function escape($data)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'escape');
        return $pluginInfo ? $this->___callPlugins('escape', func_get_args(), $pluginInfo) : parent::escape($data);
    }

    /**
     * {@inheritdoc}
     */
    public function escapeDataArgument($data)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'escapeDataArgument');
        return $pluginInfo ? $this->___callPlugins('escapeDataArgument', func_get_args(), $pluginInfo) : parent::escapeDataArgument($data);
    }

    /**
     * {@inheritdoc}
     */
    public function utf($source) : string
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'utf');
        return $pluginInfo ? $this->___callPlugins('utf', func_get_args(), $pluginInfo) : parent::utf($source);
    }

    /**
     * {@inheritdoc}
     */
    public function getConfig($config)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'getConfig');
        return $pluginInfo ? $this->___callPlugins('getConfig', func_get_args(), $pluginInfo) : parent::getConfig($config);
    }

    /**
     * {@inheritdoc}
     */
    public function isModuleOutputEnabled($moduleName = null)
    {
        $pluginInfo = $this->pluginList->getNext($this->subjectType, 'isModuleOutputEnabled');
        return $pluginInfo ? $this->___callPlugins('isModuleOutputEnabled', func_get_args(), $pluginInfo) : parent::isModuleOutputEnabled($moduleName);
    }
}
