<?php


namespace EightWire\CronHealth\Controller\HealthCheck;

class Index extends \Magento\Framework\App\Action\Action
{

    private $healthCheck;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Action\Context  $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \EightWire\CronHealth\Model\HealthCheck $healthCheck,
        \Magento\Framework\Controller\Result\RawFactory $rawResultFactory
    ) {
        $this->healthCheck = $healthCheck;
        $this->rawResultFactory = $rawResultFactory;

        parent::__construct($context);
    }

    /**
     * returns 200 or 500 response based on status of cron healthcheck
     *
     * @return \Magento\Framework\App\ResponseInterface
     * @throws \Exception
     */
    public function execute()
    {
        // @todo if cron health module isn't enabled in config return a 404 response
        // if (!$this->healthCheck->isEnabled()) {
        //     return 404; 
        // }

        $response = $this->rawResultFactory->create();

        if (!$this->healthCheck->cronIsHealthy()) {
            $response->setHeader('Content-type', 'text/plain')
                ->setHttpResponseCode(500)
                ->setContents('⚠️ Fail, cron last run '.$this->healthCheck->getMinutesSinceRun().' minutes ago');
            return $response;
        }

        $response->setHeader('Content-type', 'text/plain')
                ->setContents('👍 OK, cron last run '.$this->healthCheck->getMinutesSinceRun().' minutes ago');
        return $response;
    }
}
