<?php

namespace EightWire\CronHealth\Model;


use \Magento\Cron\Model\Schedule;

class HealthCheck
{

    const HEARTBEAT_CODE = 'eightwire_cronhealth_heartbeat';

    protected $lastHeartBeat;

    public function __construct(
        \Magento\Cron\Model\ResourceModel\Schedule\Collection $collection
    ) {
        $this->scheduleCollection = $collection;
    }

    /**
     * Is the cron task healthy
     *
     * @return bool
     * @throws \Exception
     */
    public function cronIsHealthy()
    {
        $heartBeat = $this->getLastHeartBeat();

        if (!$heartBeat) {
            return false;
        }

        if ($this->getMinutesSinceRun() > $this->getMaxInactivity()) {
            return false;
        }

        return true;
    }

    /** Max heartbeat inactivity before being marked as a failure
     * @return int
     */
    protected function getMaxInactivity()
    {
        // @todo make this configureable
        return 30;
    }

    // /** Are healthchecks enabled?
    //  * @return int
    //  */
    // public function isEnabled()
    // {
    //     // @todo make this configureable
    //     return true;
    // }


    /**
     * Get elapsed minutes since last heartbeat
     *
     * @return float|int
     * @throws \Exception
     */
    public function getMinutesSinceRun()
    {
        $lastRun = \DateTime::createFromFormat('Y-m-d H:i:s', $this->getLastHeartBeat()->getExecutedAt());
        $now = new \DateTime();
        $difference = $now->diff($lastRun);
        return  ($difference->days * 24 * 60) + ($difference->h * 60) + $difference->i;
    }

    /**
     * Find the last successful heartbeat job in the db
     *
     * @return \Magento\Cron\Model\Schedule|false
     */
    protected function getLastHeartBeat()
    {
        if (!$this->lastHeartBeat) {
            $this->scheduleCollection->addFieldToFilter('job_code', self::HEARTBEAT_CODE)
                ->addFieldToFilter('status', Schedule::STATUS_SUCCESS)
                ->getSelect()->limit(1)->order('executed_at DESC');


            $this->lastHeartBeat = $this->scheduleCollection->getFirstItem();
        }

        return $this->lastHeartBeat;

    }
}