<?php
namespace EightWire\LogRocket\Helper;

use Magento\Store\Model\ScopeInterface;

class Config extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Config paths for using throughout the code
     */
    const XML_PATH_ENABLED = 'eightwire_logrocket/general/enabled';

    const XML_PATH_IDENTIFIER = 'eightwire_logrocket/general/identifier';

    const XML_PATH_DEBUG = 'eightwire_logrocket/general/debug_enabled';

    const XML_PATH_TRACK_CUSTOMER = 'eightwire_logrocket/general/track_customer';



    public function isEnabled()
    {
        return (bool)$this->scopeConfig->getValue(self::XML_PATH_ENABLED, ScopeInterface::SCOPE_STORE);
    }


    public function isDebugEnabled()
    {
        return (bool)$this->scopeConfig->getValue(self::XML_PATH_DEBUG, ScopeInterface::SCOPE_STORE);
    }


    public function getIdentifier()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_IDENTIFIER, ScopeInterface::SCOPE_STORE);
    }

    public function trackCustomer()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_TRACK_CUSTOMER, ScopeInterface::SCOPE_STORE);
    }
}
