<?php
namespace EightWire\LogRocket\Plugin\CustomerData;

use Magento\Customer\Helper\Session\CurrentCustomer;

class Customer
{
    protected $currentCustomer;
    protected $customerSession;

    public function __construct(
        CurrentCustomer $currentCustomer,
        \Magento\Customer\Model\Session $customerSession,
        \EightWire\LogRocket\Helper\Config $configHelper
    ) {
        $this->currentCustomer = $currentCustomer;
        $this->customerSession = $customerSession;
        $this->configHelper = $configHelper;
    }

    public function afterGetSectionData(\Magento\Customer\CustomerData\Customer $subject, $result)
    {
        if ($this->configHelper->trackCustomer() && $this->customerSession->isLoggedIn()) {
            $customer = $this->currentCustomer->getCustomer();
            if ($customer->getId()) {
                $result['email'] = $customer->getEmail();
                $result['lrId'] = sha1($customer->getEmail());
            }
        }
        return $result;
    }
}
