# How to open issues for Fastly_Cdn Module

Issues are for tracking broken functionality and are intended for managing
development work to address these.

If you have an issue with usage or need general assistance using this module,
or Fastly in general please use the [support infomation](../README.md#support).

This describes what content should be added to a issue to help with an
expedient resolution.

## What to post

A good bug report contains the data necessary to reproduce, identify, locate
and address a problem in code. Where possible it should also indicate what
steps have already been taken to address the issue and their result too.

A report should be reproducible on a base install of Magento to an up to date
system with no additional modules.

At a bare minimum include:

1. OS name and version.
1. PHP version
1. Database server name and version.
1. Magento version.
1. Composer version.
1. Description of the problem. What is happening that shouldn't?
1. Description of the expected behaviour.
1. Exact steps to reproduce the error.

Additional data which can help:

1. Logs showing errors or behaviour.
1. Steps which have been taken to try address the issue.
1. Other data which indicates what may be causing the issue.
1. Stack trace if any error is seen.