<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\AdvancedSalesRule\Model\Indexer\SalesRule\Action;

/**
 * @magentoDataFixtureBeforeTransaction Magento/AdvancedSalesRule/_files/salesrule_indexer_on_schedule.php
 * @magentoDbIsolation enabled
 * @magentoAppIsolation enabled
 */
class FullTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @magentoDbIsolation enabled
     * @magentoAppIsolation enabled
     * @magentoDataFixture Magento/SalesRule/_files/rules_categories.php
     * @magentoDataFixture Magento/SalesRule/_files/rules_category.php
     */
    public function testFilterRuleSaveOnSchedule()
    {
        $objectManager = \Magento\TestFramework\Helper\Bootstrap::getObjectManager();

        /** @var \Magento\SalesRule\Model\Rule $rule */
        $rule1 = $objectManager->get(\Magento\Framework\Registry::class)
            ->registry('_fixture/Magento_SalesRule_Multiple_Categories');

        /** @var \Magento\SalesRule\Model\Rule $rule */
        $rule2 = $objectManager->get(\Magento\Framework\Registry::class)
            ->registry('_fixture/Magento_SalesRule_Category');

        /** @var \Magento\AdvancedSalesRule\Model\ResourceModel\Rule\Condition\Filter $filter */
        $filter = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()->create(
            \Magento\AdvancedSalesRule\Model\ResourceModel\Rule\Condition\Filter::class
        );

        $connection = $filter->getConnection();
        $filtersSelect = $connection->select()
            ->from($filter->getMainTable())
            ->where('rule_id in (?)', [$rule1->getRuleId(), $rule2->getRuleId()]);
        $items = $filtersSelect->query()->fetchAll();

        //test with save on schedule that prevents saving on save
        $this->assertEmpty($items);

        /** @var \Magento\AdvancedSalesRule\Model\Indexer\SalesRule\Action\Full $action */
        $action = $objectManager->create(\Magento\AdvancedSalesRule\Model\Indexer\SalesRule\Action\Full::class);
        $action->execute();

        $connection = $filter->getConnection();
        $filtersSelect = $connection->select()->from($filter->getMainTable());
        $items = $filtersSelect->query()->fetchAll();

        // verify rule_filter_id exists and remove rule_filter_id from $items
        foreach ($items as $index => $item) {
            $this->assertArrayHasKey('rule_filter_id', $items[$index]);
            unset($items[$index]['rule_filter_id']);
        }

        //test if execute generated all filters
        $this->assertEquals(
            [
                [
                    'rule_id' => $rule1->getRuleId(),
                    'group_id' => '1',
                    'weight' => '0.5',
                    'filter_text' => 'product:category:2',
                    'filter_text_generator_class' =>
                        \Magento\AdvancedSalesRule\Model\Rule\Condition\FilterTextGenerator\Product\Category::class,
                    'filter_text_generator_arguments' => '[]',
                ],
                [
                    'rule_id' => $rule1->getRuleId(),
                    'group_id' => '1',
                    'weight' => '0.5',
                    'filter_text' => 'product:category:3',
                    'filter_text_generator_class' =>
                        \Magento\AdvancedSalesRule\Model\Rule\Condition\FilterTextGenerator\Product\Category::class,
                    'filter_text_generator_arguments' => '[]',
                ],
                [
                    'rule_id' => $rule2->getRuleId(),
                    'group_id' => '1',
                    'weight' => '1',
                    'filter_text' => 'product:category:66',
                    'filter_text_generator_class' =>
                        \Magento\AdvancedSalesRule\Model\Rule\Condition\FilterTextGenerator\Product\Category::class,
                    'filter_text_generator_arguments' => '[]',
                ]
            ],
            $items
        );
    }
}
