<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-seo
 * @version   2.10.12
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\Seo\Controller\Adminhtml\System\Config\Cookie;

use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Stdlib\CookieManagerInterface;
use Mirasvit\Seo\Model\Config as Config;

class Change extends \Magento\Backend\App\Action
{
    /**
     * @var JsonFactory
     */
    protected $resultJsonFactory;
    /**
     * @var \Magento\Backend\App\Action\Context
     */
    private $context;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param JsonFactory $resultJsonFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        JsonFactory $resultJsonFactory
    ) {
        $this->context = $context;
        $this->resultJsonFactory = $resultJsonFactory;
        parent::__construct($context);
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->context->getAuthorization()->isAllowed('Mirasvit_Seo::seo');
    }

    /**
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $result = $this->_applyCookie();
        $resultCookie = "";
        if ($result === true) {
            $resultCookie = Config::COOKIE_DEL_BUTTON;
        } elseif ($result === false) {
            $resultCookie = Config::COOKIE_ADD_BUTTON;
        }

        /** @var \Magento\Framework\Controller\Result\Json $resultJson */
        $resultJson = $this->resultJsonFactory->create();
        return $resultJson->setData([
            'valid' => 1,
            'message' => $result,
            'btn_message' => $resultCookie,
        ]);
    }

    /**
     * Add/Remove Cookie
     *
     * @return \Mirasvit\Seo\Model\Cookie\Cookie
     */
    protected function _applyCookie()
    {
        return $this->_objectManager->get('Mirasvit\Seo\Model\Cookie\Cookie')
                                    ->applyCookie();
    }
}
