<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-seo
 * @version   2.10.12
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\SeoSitemap\Model\Config;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Mirasvit\Seo\Model\ResourceModel\Redirect\CollectionFactory as RedirectCollectionFactory;
use Mirasvit\SeoContent\Api\Data\RewriteInterface;
use Mirasvit\SeoContent\Api\Repository\RewriteRepositoryInterface;
use Mirasvit\SeoSitemap\Model\Config;

class LinkSitemapConfig
{
    private $scopeConfig;

    private $config;

    private $rewriteRepository;

    private $redirectCollectionFactory;

    public function __construct(
        ScopeConfigInterface       $scopeConfig,
        Config                     $config,
        RewriteRepositoryInterface $rewriteRepository,
        RedirectCollectionFactory  $redirectCollectionFactory
    ) {
        $this->scopeConfig               = $scopeConfig;
        $this->config                    = $config;
        $this->rewriteRepository         = $rewriteRepository;
        $this->redirectCollectionFactory = $redirectCollectionFactory;
    }

    public function getAdditionalLinks($store = null, bool $ignoreTitle = false): array
    {
        $conf = (string)$this->scopeConfig->getValue(
            'seositemap/frontend/additional_links',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $store
        );
        $links = [];
        $ar = explode("\n", $conf);
        $ar = array_merge($ar, $this->getSeoRewriteLinks($store));
        foreach ($ar as $v) {
            $p = explode(',', trim($v));
            if ((!isset($p[0]) || !$p[0]) || (!$ignoreTitle && (!isset($p[1]) || !$p[1]))) {
                continue;
            }

            $link['url'] = trim($p[0]);

            if (isset($p[1]) && $p[1]) {
                $link['title'] = trim($p[1]);
            }

            $links[] = new \Magento\Framework\DataObject($link);
        }

        return $links;
    }

    public function getExcludeLinks($store = null): array
    {
        $conf = (string)$this->scopeConfig->getValue(
            'seositemap/frontend/exclude_links',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $store
        );

        $links = explode("\n", trim($conf));
        $links = array_map('trim', $links);

        $links = array_diff($links, [0, null]);

        $links = array_merge($links, $this->getSeoRedirectLinks($store));

        return $links;
    }

    private function getSeoRewriteLinks($store = null): array
    {
        $links = [];

        $collection = $this->rewriteRepository->getCollection();
        $collection->addFieldToFilter(RewriteInterface::IS_ACTIVE, true)
            ->addSitemapFilter();
        if ($store) {
            $collection->addStoreFilter($store);
        }

        foreach ($collection as $item) {
            if (str_contains($item->getUrl(), '*') || (strpos($item->getUrl(), '?') === 0)) {
                continue;
            }

            if (($item->getAddToSitemap() == RewriteInterface::SITEMAP_YES)
                || ($this->config->getIncludeSeoRewrites() && ($item->getMetaRobots() == 'index,follow'))
            ) {
                $links[] = implode(',', [$item->getUrl(), $item->getTitle()]);
            }
        }

        return $links;
    }

    private function getSeoRedirectLinks($store = null): array
    {
        $links = [];

        $collection = $this->redirectCollectionFactory->create();
        $collection->addFieldToSelect('url_from')
            ->addActiveFilter();
        if ($store) {
            $collection->addStoreFilter($store);
        }

        foreach ($collection as $item) {
            if (str_contains($item->getUrlFrom(), '*') || (strpos($item->getUrlFrom(), '?') === 0)) {
                continue;
            }

            $links[] = $item->getUrlFrom();
        }

        return $links;
    }
}
