<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-seo
 * @version   2.10.12
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\SeoSitemap\Model\Config\Source\Ignore\Cms;

use Magento\Cms\Model\ResourceModel\Page\CollectionFactory;

class Pages implements \Magento\Framework\Option\ArrayInterface
{
    protected $pageCollectionFactory;

    public function __construct(
        CollectionFactory $pageCollectionFactory
    ) {
        $this->pageCollectionFactory = $pageCollectionFactory;
    }

    public function toArray(): array
    {
        $collection = $this->pageCollectionFactory->create()
            ->addFieldToFilter('is_active', true);
        $result = [];
        foreach ($collection as $v) {
            $result[$v['page_id']] = $v['title'];
        }

        return $result;
    }

    public function toOptionArray(): array
    {
        $result = [];
        foreach ($this->toArray() as $k => $v) {
            $result[] = ['value' => $k, 'label' => $v];
        }

        return $result;
    }
}
