<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-seo
 * @version   2.10.12
 * @copyright Copyright (C) 2025 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\SeoSitemap\Repository\Provider\Magezon;

use Magento\Framework\DataObject;
use Magento\Framework\ObjectManagerInterface;
use Magento\Sitemap\Helper\Data as DataHelper;
use Mirasvit\SeoSitemap\Api\Repository\ProviderInterface;

class BlogProvider implements ProviderInterface
{
    private $objectManager;

    private $dataHelper;

    public function __construct(
        ObjectManagerInterface $objectManager,
        DataHelper $sitemapData
    ) {
        $this->objectManager = $objectManager;
        $this->dataHelper    = $sitemapData;
    }

    public function getModuleName(): string
    {
        return 'Magezon_Blog';
    }

    public function isApplicable(): bool
    {
        return class_exists('Magezon\Blog\Model\Sitemap\ItemProvider\Post');
    }

    public function getTitle()
    {
        return __('Blog');
    }

    public function initSitemapItem($storeId): array
    {
        $result = [];

        $result[] = new DataObject([
            'changefreq' => $this->dataHelper->getPageChangefreq($storeId),
            'priority'   => $this->dataHelper->getPagePriority($storeId),
            'collection' => $this->getItems($storeId),
        ]);

        return $result;

    }

    public function getItems($storeId): array
    {
        $sitemapAuthor = $this->objectManager->get('Magezon\Blog\Model\Sitemap\ItemProvider\Author');
        $sitemapCategory = $this->objectManager->get('Magezon\Blog\Model\Sitemap\ItemProvider\Category');
        $sitemapPost = $this->objectManager->get('Magezon\Blog\Model\Sitemap\ItemProvider\Post');
        $sitemapTag = $this->objectManager->get('Magezon\Blog\Model\Sitemap\ItemProvider\Tag');

        $items = [];
        $items = array_merge($items, $sitemapAuthor->getItems($storeId));
        $items = array_merge($items, $sitemapCategory->getItems($storeId));
        $items = array_merge($items, $sitemapPost->getItems($storeId));
        $items = array_merge($items, $sitemapTag->getItems($storeId));

        return $items;
    }
}
