<?php
namespace Windcave\Payments\Block\PxFusion\Adminhtml;

use \Magento\Framework\View\Element\Template\Context;

/**
 * PxFusion payment form block
 */
class Form extends \Magento\Payment\Block\Form
{
    /**
     * @var \Magento\Framework\App\ObjectManager
     */
    private $objectManager;
    /**
     * @var \Magento\Quote\Model\Quote
     */
    private $quote;
    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param array $data
     */
    public function __construct(Context $context, array $data = [])
    {
        parent::__construct($context, $data);
        $this->_template = 'Windcave_Payments::pxfusion/form.phtml';
        
        $this->objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $this->_logger = $this->objectManager->get(\Windcave\Payments\Logger\DpsLogger::class);
        $now = new \DateTime('now');
        
        $this->setData("expiry_month", date('n'));
        $this->setData("expiry_year", (date('Y') - 2000));
        
        // do not submit
        $quoteSession = $this->objectManager->get(\Magento\Backend\Model\Session\Quote::class);
        $this->quote = $quoteSession->getQuote();
        $quoteId = $this->quote->getId();
        $this->_logger->info(__METHOD__ . " quoteId: {$quoteId}");
        
        $this->_logger->info(__METHOD__ . "  " . $this->getData('expiry_year'));
    }

    /**
     * Retrieve expiry months
     *
     * @return array
     */
    public function getExpiryMonths()
    {
        $this->_logger->info(__METHOD__);
        $months = $this->getData('expiry_months');
        if ($months === null) {
            $months = [
                0 => __('Month')
            ];
            $this->_logger->info(__METHOD__);
            for ($index = 1; $index < 13; $index++) {
                $item = sprintf("%02d", $index);
                $months[$item] = $item;
            }
            $this->setData('expiry_months', $months);
        }
        
        return $months;
    }

    /**
     * Retrieve expiry years
     *
     * @return array
     */
    public function getExpiryYears()
    {
        $this->_logger->info(__METHOD__);
        $years = $this->getData('expiry_years');
        if ($years === null) {
            $years = [0 => __('Year')];
            $first = date('Y');//(int)$this->_date->date('Y');
            for ($index = 0; $index <= 10; $index++) {
                $year = $first + $index;
                $key =  sprintf("%02d", ($year - 2000));
                $years[$key] = $year;
            }
            $this->setData('expiry_years', $years);
        }
        
        return $years;
    }

    /**
     * Returns the service URL
     *
     * @return string
     */
    public function getServiceUrl()
    {
        $url = $this->getUrl("pxpay2/pxfusion/createtransaction", [
            '_secure' => true
        ]);
        $this->_logger->info(__METHOD__ . " url: {$url}");
        return $url;
    }

    /**
     * Verifies if Cardholder name is required from configuration
     *
     * @return bool
     */
    public function requireCardholderName()
    {
        $configuration = $this->objectManager->get(\Windcave\Payments\Helper\PxFusion\Configuration::class);
        return $configuration->getRequireCardholderName($this->quote->getStoreId());
    }
}
