<?php
namespace Windcave\Payments\Logger;

use \Monolog\Logger;

// Refer to vendor\monolog\monolog\src\Monolog\Logger.php
// Log to separate file
class DpsLogger extends \Monolog\Logger
{

    /**
     * Constructor
     *
     * @param string $name
     * @param array $handlers
     * @param array $processors
     */
    public function __construct(
        $name,
        array $handlers = [],
        array $processors = []
    ) {
        parent::__construct($name, $handlers, $processors);
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $registry = $objectManager->get(\Magento\Framework\Registry::class);
        try {
            $productMetadata = $objectManager->get(\Magento\Framework\App\ProductMetadataInterface::class);
            $version = $productMetadata->getVersion();
            $requestId = $registry->registry('requestId');
            if (!isset($requestId)) {
                $registry->register('requestId', uniqid());
                $requestId = $registry->registry('requestId');
            }

            $this->pushProcessor(function ($record) use ($version, $requestId) {
                $record['extra']['magentoVersion'] = $version;
                $record['extra']['requestId'] = $requestId;
                return $record;
            });
        } catch (\Exception $e) {
            $psrlogger = $objectManager->get(\Psr\Log\LoggerInterface::class);
            $psrlogger->critical($e->getMessage());
             // print 'Caught exception: ',  $e->getMessage(), "\n";
        }
    }

    /**
     * Logs a warning
     *
     * @param string $message
     * @param array $context
     */
    public function warn($message, array $context = [])
    {
        if (!function_exists('warn')) {
            parent::warning($message, $context);
        } else {
            parent::warn($message, $context);
        }
    }
}
