<?php

namespace Asics\Analytics\Rewrite\Helper;

use Magento\Framework\App\Helper\Context;
use Magento\GoogleTagManager\Helper\Data;
use Asics\Analytics\Helper\Data as AsicsAnalyticsData;

class GoogleTagManagerData extends Data
{
    /**
     * @var AsicsAnalyticsData
     */
    protected $asicsAnalyticsData;

    /**
     * GoogleTagManagerData constructor.
     *
     * @param AsicsAnalyticsData $asicsAnalyticsData
     * @param Context $context
     */
    public function __construct(
        AsicsAnalyticsData $asicsAnalyticsData,
        Context $context
    ) {
        $this->asicsAnalyticsData = $asicsAnalyticsData;
        parent::__construct($context);
    }

    /**
     * Whether GA Plus is ready to use
     *
     * @param null|string $store
     * @return bool
     */
    public function isGoogleAnalyticsAvailable($store = null)
    {
        if ($this->asicsAnalyticsData->isEnabled()) {
            return parent::isGoogleAnalyticsAvailable($store);
        }
        return false;
    }

    /**
     * Whether GTM is ready to use
     *
     * @param mixed $store
     * @return bool
     */
    public function isTagManagerAvailable($store = null)
    {
        if ($this->asicsAnalyticsData->isEnabled()) {
            return parent::isTagManagerAvailable($store);
        }
        return false;
    }
}
