<?php

namespace Asics\Analytics\Rewrite\Model\Config;

use Asics\Analytics\Helper\Data as AsicsAnalyticsData;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\GoogleTagManager\Model\Config\TagManagerConfig as MagentoTagManagerConfig;

class TagManagerConfig extends MagentoTagManagerConfig
{
    /**
     * @var AsicsAnalyticsData
     */
    protected $asicsAnalyticsData;

    /**
     * TagManagerConfig constructor.
     *
     * @param AsicsAnalyticsData $asicsAnalyticsData
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        AsicsAnalyticsData $asicsAnalyticsData,
        ScopeConfigInterface $scopeConfig
    ) {
        parent::__construct($scopeConfig);
        $this->asicsAnalyticsData = $asicsAnalyticsData;
    }

    /**
     * Whether GA Plus is ready to use
     *
     * @param mixed $store
     * @return bool
     */
    public function isGoogleAnalyticsAvailable($store = null): bool
    {
        if ($this->asicsAnalyticsData->isEnabled()) {
            return parent::isGoogleAnalyticsAvailable($store);
        }
        return false;
    }

    /**
     * Whether GTM is ready to use
     *
     * @param mixed $store
     * @return bool
     */
    public function isTagManagerAvailable($store = null): bool
    {
        if ($this->asicsAnalyticsData->isEnabled()) {
            return parent::isTagManagerAvailable($store);
        }
        return false;
    }
}
