<?php

declare(strict_types=1);

namespace Asics\Verifone\Plugin;

use Exception;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\ResourceModel\Order as OrderResource;
use Verifone\Hosted\Model\Verifone;

/**
 * Set the flag to allow for email to be sent
 *
 * @see \Asics\Verifone\Observer\PreventPendingPaymentSalesEmail
 */
class SetSendEmailFlag
{
    public function __construct(
        private readonly OrderResource $orderResource,
    ) {
    }

    /**
     * After payment has been processed, allow for email to be sent
     *
     * @param Verifone $subject
     * @param Order $result
     * @param Order $order
     * @return Order
     * @throws Exception
     */
    public function afterPostProcessing(Verifone $subject, Order $result, Order $order): Order
    {
        if ($this->shouldSendEmail($order)) {
            $order->setSendEmail(true);
            $this->orderResource->saveAttribute($order, 'send_email');
        }

        return $result;
    }

    /**
     * Check if processing Verifone order
     *
     * @param Order $order
     * @return bool
     */
    public function shouldSendEmail(Order $order): bool
    {
        return $order->getPayment()->getMethod() === Verifone::CODE
            && $order->getStatus() === 'processing';
    }
}
