<?php

namespace BrittainWynyard\Fastly\Plugin;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\HTTP\Adapter\Curl as FrameworkCurl;

/**
 * Class Curl
 */
class Curl
{
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function beforeWrite(FrameworkCurl $subject, $method, $url, $http_ver = '1.1', $headers = [], $body = '')
    {
        if ($method == "PURGE") {
            $configPrefix = 'system/full_page_cache/fastly/bypass_akamai/';
            $bypassAkamai = $this->scopeConfig->getValue($configPrefix . 'enabled');

            if ($bypassAkamai) {
                $secureReplaceableDomain = $this->scopeConfig->getValue($configPrefix . 'search_domain_secure');
                $unsecureReplaceableDomain = $this->scopeConfig->getValue($configPrefix . 'search_domain_unsecure');
                $secureReplaceDomain = $this->scopeConfig->getValue($configPrefix . 'replace_domain_secure');
                $unsecureReplaceDomain = $this->scopeConfig->getValue($configPrefix . 'replace_domain_unsecure');
                $hostHeader = $this->scopeConfig->getValue($configPrefix . 'host_header');

                $url = str_replace($secureReplaceableDomain, $secureReplaceDomain, $url);
                $url = str_replace($unsecureReplaceableDomain, $unsecureReplaceDomain, $url);
                $headers["Host"] = $hostHeader;

                return [$method, $url, $http_ver, $headers, $body];
            }
        }
        return null;
    }
}
