<?php
/**
 * BrittainWynyard GiftcardAccount Custom History Model
 *
 * @package BrittainWynyard_GiftcardAccount
 */

namespace BrittainWynyard\GiftcardAccount\Model;

use Magento\GiftCardAccount\Model\History as CoreHistory;

/**
 * Extended Gift Card Account History Model
 * Adds support for custom additional info from Accredo sync
 */
class History extends CoreHistory
{
    /**
     * Get info about update context
     *
     * Override core method to support custom additional info from Accredo sync
     *
     * @return string
     */
    protected function _getUpdatedAdditionalInfo()
    {
        // Check if the gift card account has custom additional info set
        if ($this->getGiftcardaccount() && $this->getGiftcardaccount()->getData('history_additional_info')) {
            return $this->getGiftcardaccount()->getData('history_additional_info');
        }

        // Fall back to core behavior (empty string)
        return parent::_getUpdatedAdditionalInfo();
    }

    /**
     * Get info about creation context
     *
     * Override to support custom creation info from Accredo sync
     *
     * @return \Magento\Framework\Phrase|string
     */
    protected function _getCreatedAdditionalInfo()
    {
        // Check if the gift card account has custom additional info set
        if ($this->getGiftcardaccount() && $this->getGiftcardaccount()->getData('history_additional_info')) {
            return $this->getGiftcardaccount()->getData('history_additional_info');
        }

        // Fall back to core behavior (order context)
        return parent::_getCreatedAdditionalInfo();
    }
}
