<?php declare(strict_types=1);
namespace Overdose\Catalog\ViewModel;

use Magento\Catalog\Model\Product\Attribute\Source\Status;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class DiscountLableViewModel implements ArgumentInterface
{
    /**
     * [hasGeneralTierPrice description]
     * @param  [type]  $_product [description]
     * @return boolean           [description]
     */
    public function hasGeneralTierPrice($_product) {
        $hasGeneralTierPrice = false;

        if ($_product->getTypeId() == "configurable") {
            $childProducts = $_product->getTypeInstance()->getUsedProducts($_product);
            foreach ($childProducts as $childProduct) {
                if ($childProduct->getStatus() != Status::STATUS_ENABLED) {
                    continue;
                }

                $tierPrice = $childProduct->getData('tier_price');
                if (!$tierPrice) {
                    continue;
                }

                foreach ($tierPrice as $price) {
                     if ($price && array_key_exists('cust_group', $price)) {
                        if ($price['cust_group'] == 1) {
                            $hasGeneralTierPrice  = true;
                            break;
                        }
                    }
                }

                if ($hasGeneralTierPrice) {
                    break;
                }
            }
        } else if ($_product->getTypeId() == "simple") {
            $tierPrice = $_product->getData('tier_price');

            if ($tierPrice) {
                foreach ($tierPrice as $price) {
                    if ($price && array_key_exists('cust_group', $price)) {
                        if ($price['cust_group'] == 1) {
                            $hasGeneralTierPrice = true;
                            break;
                        }
                    }
                }
            }
        }

         return $hasGeneralTierPrice;
    }

    /**
     * Get the hard-coded discount text
     *
     * @return string
     */
    public function getDiscountText(): string
    {
        return 'OneASICS member pricing applied';
    }
}
