define([
    'jquery',
], function ($) {
    return function (config, element) {
        var fauxSorterElement = element;
        var sorterElement = fauxSorterElement.parentElement.querySelector('#sorter');
        var sorterOptions = sorterElement.children;

        var fauxSorterOptions = '';

        for (var i = 0; i < sorterOptions.length; i++) {
            var sorterOption = sorterOptions[i];

            //make both ascending and descending
            if (sorterOption.value == 'price') {
                fauxSorterOptions += '<option value="' + sorterOption.value + '" data-dir="asc">$-$$</option>';
                fauxSorterOptions += '<option value="' + sorterOption.value + '" data-dir="desc">$$-$</option>';
            }
            else if (sorterOption.value == 'name') {
                fauxSorterOptions += '<option value="' + sorterOption.value + '" data-dir="asc">A_Z</option>';
                fauxSorterOptions += '<option value="' + sorterOption.value + '" data-dir="desc">Z_A</option>';
            }
            else if (sorterOption.value == 'position') {
                fauxSorterOptions += '<option value="' + sorterOption.value + '" data-dir="asc">Featured</option>';
            }
            else if(sorterOption.value == 'relevance'){
                fauxSorterOptions = '<option value="' + sorterOption.value + '" data-dir="asc">Relavance</option>' + fauxSorterOptions;
            }
            else {
                fauxSorterOptions += '<option value="' + sorterOption.value + '" data-dir="asc">' + sorterOption.textContent + ' ASC </option>';
                fauxSorterOptions += '<option value="' + sorterOption.value + '" data-dir="desc">' + sorterOption.textContent + ' DESC </option>';
            }
        }

        fauxSorterElement.innerHTML = fauxSorterOptions;

        //determine if selected
        var urlQueryString = window.location.search;
        var urlQueryStringBreakdown = new URLSearchParams(urlQueryString);
        var urlQueryStringValue = urlQueryStringBreakdown.get('product_list_order');
        var urlQueryStringDir = urlQueryStringBreakdown.get('product_list_dir');
        var urlQueryStringSearch = urlQueryStringBreakdown.get('q');
        var urlQueryStringProductPerList = urlQueryStringBreakdown.get('product_list_limit');

        if (urlQueryStringValue) {
            if (urlQueryStringDir == 'desc') {
                fauxSorterElement.querySelector('option[value="' + urlQueryStringValue + '"][data-dir="desc"]').selected = true;
            }
            else {
                fauxSorterElement.querySelector('option[value="' + urlQueryStringValue + '"][data-dir="asc"]').selected = true;
            }
        }

        fauxSorterElement.addEventListener('change', function (e) {
            //get selected option value
            var selectedSortOptionValue = e.currentTarget.selectedOptions[0].value;

            //get selected option dir
            var selectedSortOptionDir = e.currentTarget.selectedOptions[0].dataset.dir;

            var selectedSortOptionValueQuery = '?product_list_order=' + selectedSortOptionValue;
            var selectedSortOptionDirQuery = '&product_list_dir=' + selectedSortOptionDir;
            var searchQuery = '';
            var productPerListQuery = '';
            var filterQuery = '';

            if(urlQueryStringSearch){
                searchQuery = '&q=' + urlQueryStringSearch;
            }
            if(urlQueryStringProductPerList){
                productPerListQuery = '&product_list_limit=' + urlQueryStringProductPerList;
            }

            //check filter query



            //change url
            var url = window.location.origin + window.location.pathname + selectedSortOptionValueQuery + selectedSortOptionDirQuery + searchQuery + productPerListQuery + filterQuery;
            window.location = url;
        })
    }
});
