<?php

declare(strict_types=1);

namespace Overdose\Checkout\Block\Swatches\Product\Renderer\Listing;

use Magento\Catalog\Block\Product\Context;
use Magento\Catalog\Helper\Product as CatalogProduct;
use Magento\Catalog\Model\Layer\Resolver;
use Magento\ConfigurableProduct\Helper\Data;
use Magento\ConfigurableProduct\Model\ConfigurableAttributeData;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable\Variations\Prices;
use Magento\Customer\Helper\Session\CurrentCustomer;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Json\DecoderInterface;
use Magento\Framework\Json\EncoderInterface;
use Magento\Framework\Locale\Format;
use Magento\Framework\Pricing\PriceCurrencyInterface;
use Magento\Framework\Stdlib\ArrayUtils;
use Magento\Swatches\Helper\Data as SwatchData;
use Magento\Swatches\Helper\Media;
use Magento\Swatches\Model\SwatchAttributesProvider;

/**
 * Swatch renderer block in Crosssel Checkout cart page
 */
class Configurable extends \Magento\Swatches\Block\Product\Renderer\Listing\Configurable
{
    /** @var DecoderInterface */
    private $jsonDecoder;

    /**
     * @param Context $context
     * @param ArrayUtils $arrayUtils
     * @param EncoderInterface $jsonEncoder
     * @param Data $helper
     * @param CatalogProduct $catalogProduct
     * @param CurrentCustomer $currentCustomer
     * @param PriceCurrencyInterface $priceCurrency
     * @param ConfigurableAttributeData $configurableAttributeData
     * @param SwatchData $swatchHelper
     * @param Media $swatchMediaHelper
     * @param array $data
     * @param SwatchAttributesProvider|null $swatchAttributesProvider
     * @param Format|null $localeFormat
     * @param Prices|null $variationPrices
     * @param Resolver|null $layerResolver
     * @param DecoderInterface|null $jsonDecoder
     */
    public function __construct(
        Context $context,
        ArrayUtils $arrayUtils,
        EncoderInterface          $jsonEncoder,
        Data                      $helper,
        CatalogProduct            $catalogProduct,
        CurrentCustomer           $currentCustomer,
        PriceCurrencyInterface    $priceCurrency,
        ConfigurableAttributeData $configurableAttributeData,
        SwatchData                $swatchHelper,
        Media                     $swatchMediaHelper,
        array                     $data = [],
        SwatchAttributesProvider  $swatchAttributesProvider = null,
        Format                    $localeFormat = null,
        Prices                    $variationPrices = null,
        Resolver                  $layerResolver = null,
        DecoderInterface         $jsonDecoder = null
    ) {
        parent::__construct(
            $context,
            $arrayUtils,
            $jsonEncoder,
            $helper,
            $catalogProduct,
            $currentCustomer,
            $priceCurrency,
            $configurableAttributeData,
            $swatchHelper,
            $swatchMediaHelper,
            $data,
            $swatchAttributesProvider,
            $localeFormat,
            $variationPrices,
            $layerResolver
        );

        $this->jsonDecoder = $jsonDecoder ?: ObjectManager::getInstance()
            ->get(DecoderInterface::class);
    }
    /**
     * Retrieve swatch attributes data
     * @return array
     */
    protected function getSwatchAttributesData()
    {
        return \Magento\Swatches\Block\Product\Renderer\Configurable::getSwatchAttributesData();
    }

    /**
     * Additional configuration for swatches in JSON format
     *
     * @return string
     */
    public function getJsonConfig()
    {
        $result = parent::getJsonConfig();
        $config = $this->jsonDecoder->decode($result);
        $config['updateQtyBySwatch'] = false;
        $config['forceDisplayControlLabel'] = true;
        $attributes = $config['attributes']?? [];
        $attributes = array_map(function($attribute){
            $attribute['label'] = __('Select %1', str_replace(':', '', $attribute['label']));
            return $attribute;
        }, $attributes);
        $config['attributes'] = $attributes;
        return $this->jsonEncoder->encode($config);
    }
}
