<?php

namespace Overdose\DataLayer\Observer\Purchase;

use Magento\Checkout\Model\Session;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\Event\ObserverInterface;
use Overdose\DataLayer\Helper\Ec;

class Products implements ObserverInterface
{
    /**
     * @var Ec
     */
    protected $ec;

    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * @var CustomerSession
     */
    protected $customerSession;

    /**
     * @param Ec $ec
     * @param Session $checkoutSession
     * @param CustomerSession $customerSession
     */
    public function __construct
    (
        Ec $ec,
        Session $checkoutSession,
        CustomerSession $customerSession
    ) {
        $this->ec = $ec;
        $this->checkoutSession = $checkoutSession;
        $this->customerSession = $customerSession;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            $transport = $observer->getData('transport');
            $productData = $transport->getData('product')->getData();
            $quoteItemData = $transport->getData('quote_item');
            $data = new \Magento\Framework\DataObject();
            $data->setItemId($productData['item_id']);
            $data->setItemName($productData['item_name']);
            $product = $this->ec->getProductBySku($productData['item_id']);
            if ($product) {
                $data->setAffiliation($this->ec->getAffiliation($product));
                $data->setItemBrand($this->ec->getAffiliation($product));
                $data->setItemVariant($this->ec->getProductColor($product));
                $data->setItemWidth($this->ec->getProductWidth($product));
                $odAddToCartSession = $this->customerSession->getOdAddToCartSession();
                $data->setItemListName($this->ec->getSessionItemListName($odAddToCartSession, $product));
                $data->setItemListId($this->ec->getSessionItemListId($odAddToCartSession, $product));
                $data->setPrice($productData['price']);
                $data->setQuantity($productData['quantity']);
                if (isset($productData['coupon']) && $productData['coupon']) {
                    $data->setCouponCode($productData['coupon']);
                }
                if ($quoteItemData->getDiscountAmount()) {
                    $data->setDiscountAmount((float)$quoteItemData->getDiscountAmount());
                }
                $childProduct = $this->ec->getProductBySku($productData['variant_id']);
                if ($childProduct && $childProduct->getId()) {
                    $size = $this->ec->getSize($childProduct);
                    if ($size) {
                        $data->setItemSize($size);
                    }
                }
                $categoryData = $this->ec->getCategoryData($product);
                $data->addData($categoryData);
            }

            $transport->setData('product', $data);
            $this->customerSession->setOdAddToCartSession([]);
        } catch (\Exception $e) {
        }

        return $this;
    }

}
