<?php

namespace Overdose\DataLayer\Observer;

use Magento\Checkout\Model\Session;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\Event\ObserverInterface;
use Overdose\DataLayer\Helper\Ec;
use Magento\Framework\Stdlib\CookieManagerInterface;

class Remove implements ObserverInterface
{
    /**
     * @var Ec
     */
    protected $ec;

    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * @var CustomerSession
     */
    protected $customerSession;

    /**
     * @var CookieManagerInterface
     */
    protected CookieManagerInterface $cookieManager;

    /**
     * @param Ec $ec
     * @param Session $checkoutSession
     * @param CookieManagerInterface $cookieManager
     * @param CustomerSession $customerSession
     */
    public function __construct
    (
        Ec $ec,
        Session $checkoutSession,
        CookieManagerInterface $cookieManager,
        CustomerSession $customerSession
    ) {
        $this->ec = $ec;
        $this->checkoutSession = $checkoutSession;
        $this->cookieManager = $cookieManager;
        $this->customerSession = $customerSession;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $coupon = null;
        try {
            $quote = $this->checkoutSession->getQuote();
            if ($quote && $quote->getCouponCode()) {
                $coupon = $quote->getCouponCode();
            }
        } catch (\Exception $exception) {

        }
        try {
            $odAddToCartSession = $this->customerSession->getOdAddToCartSession();
            $transport = $observer->getData('transport');
            $product = $transport->getData('product');
            $product = $this->ec->getProductBySku($product->getSku());
            $attributes = $transport->getData('attributes');
            $item = $transport->getData('item');
            if ($product && $product->getId()) {
                if ($item->getProductId()) {
                    $parentProduct = $this->ec->getProductById($item->getProductId());
                    $categoryData = $this->ec->getCategoryData($parentProduct);
                } else {
                    $categoryData = $this->ec->getCategoryData($product);
                }
                $productWidth = $this->ec->getProductWidth($product);
                $productColor = $this->ec->getProductColor($product);
                $variantProduct = $this->ec->getProductBySku($item->getSku());
                $size = $this->ec->getSize($variantProduct);
                if ($size) {
                    $attributes['item_size'] = $size;
                }
                if ($coupon) {
                    $attributes['coupon'] = $coupon;
                }
                if ($item->getDiscountAmount()) {
                    $attributes['discount'] = (float)$item->getDiscountAmount();
                }
                $affiliation = $this->ec->getAffiliation($product);
                $attributes['affiliation'] = $affiliation;
                $attributes['item_brand'] = $affiliation;
                $attributes['item_variant'] = $productColor;
                if ($productWidth) {
                    $attributes['item_width'] = $productWidth;
                }
                $attributes['item_list_id'] = $this->ec->getSessionItemListId($odAddToCartSession, $product);
                $attributes['item_list_name'] = $this->ec->getSessionItemListName($odAddToCartSession, $product);
                $attributes = array_merge($attributes, $categoryData);
                $transport->setAttributes($attributes);
            }
        } catch (\Exception $e) {
        }

        return $this;
    }


}
