<?php
/**
 * Copyright © Overdose Digital. All rights reserved.
 */
namespace Overdose\Klaviyo\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Overdose\Klaviyo\Helper\Data as KlaviyoHelper;
use Psr\Log\LoggerInterface;

class CustomerLogin implements ObserverInterface
{
    /**
     * @var KlaviyoHelper
     */
    protected $klaviyoHelper;

    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * @param KlaviyoHelper $klaviyoHelper
     * @param LoggerInterface $logger
     */
    public function __construct(
        KlaviyoHelper $klaviyoHelper,
        LoggerInterface $logger
    ) {
        $this->klaviyoHelper = $klaviyoHelper;
        $this->logger = $logger;
    }

    /**
     * Observer for customer_login event
     *
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        try {
            $customer = $observer->getEvent()->getCustomer();
            if ($customer && $customer->getId()) {
                $this->klaviyoHelper->trackLoginEvent($customer);
            }
        } catch (\Exception $e) {
            $this->logger->error('Error in Overdose_Klaviyo CustomerLogin observer: ' . $e->getMessage());
        }
    }
}
