define([
    'jquery',
    'Magento_Customer/js/model/customer',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/url-builder',
    'mage/url',
    'Magento_Checkout/js/model/error-processor',
    'Magento_Ui/js/model/messageList',
    'mage/translate'
], function ($, customer, quote, urlBuilder, urlFormatter, errorProcessor, messageContainer, $t) {
    'use strict';

    return function (Shipping) {
        return Shipping.extend({
            validateShippingInformation: function () {
                if (this._super()) {
                    return this.validateComment();
                }

                return false;
            },

            validateComment: function () {
                var isCustomer = customer.isLoggedIn(),
                    form = this.getForm(),
                    comment = form.find('.order-comment').val(),
                    quoteId = quote.getQuoteId(),
                    url;

                if (this.hasMaxLength() && comment.length > this.getMaxLength()) {
                    messageContainer.addErrorMessage({ message: $t("Comment is too long") });
                    return false;
                }

                if (isCustomer) {
                    url = urlBuilder.createUrl('/carts/mine/set-order-comment', {})
                } else {
                    url = urlBuilder.createUrl('/guest-carts/:cartId/set-order-comment', {cartId: quoteId});
                }

                var payload = {
                    cartId: quoteId,
                    orderComment: {
                        comment: comment
                    }
                };

                if (!payload.orderComment.comment) {
                    return true;
                }

                var result = true;

                $.ajax({
                    url: urlFormatter.build(url),
                    data: JSON.stringify(payload),
                    global: false,
                    contentType: 'application/json',
                    type: 'PUT',
                    async: false
                }).done(
                    function (response) {
                        result = true;
                    }
                ).fail(
                    function (response) {
                        result = false;
                        errorProcessor.process(response);
                    }
                );

                return result;
            },

            getForm: function () {
                return $('.order-comment-form');
            },

            hasMaxLength: function () {
                return window.checkoutConfig.comment_max_length > 0;
            },

            getMaxLength: function () {
                return window.checkoutConfig.comment_max_length;
            }
        });
    }
});
