<?php

namespace Overdose\ProductBanners\Model\Product\Type;

use Magento\Framework\Exception\LocalizedException;

class Banner extends \Magento\Catalog\Model\Product\Type\AbstractType
{
    /**
     * constant determinate product type
     */
    const PRODUCT_TYPE_BANNER = 'banner';

    /**
     * Check is virtual product
     *
     * @param \Magento\Catalog\Model\Product $product
     * @return bool
     */
    public function isVirtual($product)
    {
        return true;
    }

    /**
     * Check that product of this type has weight
     *
     * @return bool
     */
    public function hasWeight()
    {
        return false;
    }

    /**
     * Delete data specific for Virtual product type
     *
     * @param \Magento\Catalog\Model\Product $product
     * @return void
     */
    public function deleteTypeSpecificData(\Magento\Catalog\Model\Product $product)
    {
    }

    /**
     * Protect to add banner to cart and wishlist
     * @param  \Magento\Framework\DataObject $buyRequest
     * @param  \Magento\Catalog\Model\Product $product
     * @param  string $processMode
     * @throws LocalizedException
     */
    protected function _prepareProduct(\Magento\Framework\DataObject $buyRequest, $product, $processMode)
    {
        throw new LocalizedException(__('Banner can\'t be added to cart or wishlist'));
    }
}
