<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Overdose\UrlSubpath\Plugin\Frontend\Magento\Store\App\Request;

class PathInfoProcessor
{

    public function __construct(
        \Overdose\UrlSubpath\Helper\Config $helper
    ) {
        $this->configHelper = $helper;
    }

    public function aroundProcess(
        \Magento\Store\App\Request\PathInfoProcessor $subject,
        \Closure $proceed,
        $request,
        $pathInfo
    ) {
        $pathInfo = $proceed($request, $pathInfo);

        if ($this->configHelper->isEnabled()) {
            $subdir = $this->configHelper->getSubDirectory();
            if (!empty($subdir)) {
                if (!$request->isDirectAccessFrontendName($subdir)) {
                    $pathInfo = $this->trimStoreCodeFromPathInfo($pathInfo, $subdir);
                } else {
                    //no route in case we're trying to access a store that has the same code as a direct access
                    $request->setActionName(\Magento\Framework\App\Router\Base::NO_ROUTE);
                }
            }
        }

        return $pathInfo;
    }

    /**
     * Trim store code from path info string if exists
     *
     * @param string $pathInfo
     * @param string $storeCode
     * @return string
     */
    private function trimStoreCodeFromPathInfo(string $pathInfo, string $storeCode) : ?string
    {
        if (substr($pathInfo, 0, strlen('/' . $storeCode)) == '/'. $storeCode) {
            $pathInfo = substr($pathInfo, strlen($storeCode)+1);
        }
        return empty($pathInfo) ? '/' : $pathInfo;
    }
}

